/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.google.common.base.Objects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.ShellCommandException;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgVersion
implements Comparable<HgVersion> {
    private static final Logger LOGGER = Logger.getInstance(HgVersion.class);
    private static final Pattern HG_VERSION_PATTERN = Pattern.compile(".+\\(\\s*\\S+\\s+(\\d+)\\.(\\d+)[\\.]?(\\d)?.*\\s*\\)\\s*.*\\s*", 2);
    private static final Pattern HG_UNSUPPORTED_EXTENSION = Pattern.compile("\\*\\*\\*\\s*failed to import\\s+extension\\s+([a-zA-z0-9\\.-]+).*", 2);
    public static final HgVersion MIN = new HgVersion(2, 0, 1);
    public static final HgVersion AMEND_SUPPORTED = new HgVersion(2, 2, 0);
    public static final HgVersion BUILT_IN_FUNCTION_SUPPORTED = new HgVersion(2, 6, 0);
    public static final HgVersion PARENT_REVISION_TEMPLATES_SUPPORTED = new HgVersion(2, 4, 0);
    public static final HgVersion BRANCH_HEADS_BASE_SERVED_FILE_EXIST = new HgVersion(2, 5, 0);
    public static final HgVersion BRANCH2_FILE_EXIST = new HgVersion(2, 9, 0);
    public static final HgVersion IGNORE_WHITESPACE_DIFF_IN_ANNOTATIONS = new HgVersion(2, 1, 0);
    private static final HgVersion LARGEFILES_WITH_FOLLOW_SUPPORTED = new HgVersion(2, 7, 0);
    public static final HgVersion NULL = new HgVersion(0, 0, 0);
    private final int myMajor;
    private final int myMiddle;
    private final int myMinor;
    private final Set<String> myUnsupportedExtensions;

    public HgVersion(int major, int middle, int minor) {
        this(major, middle, minor, Collections.emptySet());
    }

    public HgVersion(int major, int middle, int minor, Set<String> unsupportedExtensions) {
        this.myMajor = major;
        this.myMiddle = middle;
        this.myMinor = minor;
        this.myUnsupportedExtensions = unsupportedExtensions;
    }

    public static HgVersion parseVersionAndExtensionInfo(String output, List<String> errorLines) throws ParseException {
        if (StringUtil.isEmptyOrSpaces((String)output)) {
            throw new ParseException("Empty hg version output: " + output, 0);
        }
        Matcher matcher = HG_VERSION_PATTERN.matcher(output);
        if (matcher.matches()) {
            return new HgVersion(HgVersion.getIntGroup(matcher, 1), HgVersion.getIntGroup(matcher, 2), HgVersion.getIntGroup(matcher, 3), HgVersion.parseUnsupportedExtensions(errorLines));
        }
        LOGGER.error("Couldn't identify hg version: " + output);
        throw new ParseException("Unsupported format of hg version output: " + output, 0);
    }

    public static Set<String> parseUnsupportedExtensions(List<String> errorLines) {
        HashSet<String> extensions = new HashSet<String>();
        if (errorLines.isEmpty()) {
            return extensions;
        }
        for (String line : errorLines) {
            Matcher matcher = HG_UNSUPPORTED_EXTENSION.matcher(line);
            if (!matcher.matches()) continue;
            extensions.add(matcher.group(1));
        }
        return extensions;
    }

    private static int getIntGroup(Matcher matcher, int group) {
        if (group > matcher.groupCount() + 1) {
            return 0;
        }
        String match = matcher.group(group);
        if (StringUtil.isEmptyOrSpaces((String)match)) {
            return 0;
        }
        return Integer.parseInt(match);
    }

    public static HgVersion identifyVersion(String executable) throws ShellCommandException, InterruptedException, ParseException {
        HgCommandResult versionResult = HgUtil.getVersionOutput(executable);
        return HgVersion.parseVersionAndExtensionInfo(versionResult.getRawOutput(), versionResult.getErrorLines());
    }

    public boolean isSupported() {
        return this.compareTo(MIN) >= 0;
    }

    public boolean isAmendSupported() {
        return this.compareTo(AMEND_SUPPORTED) >= 0;
    }

    public boolean isBuiltInFunctionSupported() {
        return this.compareTo(BUILT_IN_FUNCTION_SUPPORTED) >= 0;
    }

    public boolean isLargeFilesWithFollowSupported() {
        return this.compareTo(LARGEFILES_WITH_FOLLOW_SUPPORTED) >= 0;
    }

    public boolean isParentRevisionTemplateSupported() {
        return this.compareTo(PARENT_REVISION_TEMPLATES_SUPPORTED) >= 0;
    }

    public boolean isIgnoreWhitespaceDiffInAnnotationsSupported() {
        return this.compareTo(IGNORE_WHITESPACE_DIFF_IN_ANNOTATIONS) >= 0;
    }

    public boolean hasBranchHeadsBaseServed() {
        return this.compareTo(BRANCH_HEADS_BASE_SERVED_FILE_EXIST) >= 0 && this.compareTo(BRANCH2_FILE_EXIST) < 0;
    }

    public boolean hasBranch2() {
        return this.compareTo(BRANCH2_FILE_EXIST) >= 0;
    }

    public boolean hasUnsupportedExtensions() {
        return !this.myUnsupportedExtensions.isEmpty();
    }

    public Set<String> getUnsupportedExtensions() {
        return this.myUnsupportedExtensions;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HgVersion)) {
            return false;
        }
        return this.compareTo((HgVersion)obj) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myMajor, this.myMiddle, this.myMinor});
    }

    @Override
    public int compareTo(HgVersion o) {
        int d = this.myMajor - o.myMajor;
        if (d != 0) {
            return d;
        }
        d = this.myMiddle - o.myMiddle;
        if (d != 0) {
            return d;
        }
        return this.myMinor - o.myMinor;
    }

    public String toString() {
        return this.myMajor + "." + this.myMiddle + "." + this.myMinor;
    }
}

