/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import java.util.regex.Pattern;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgReferenceValidator
implements InputValidatorEx {
    private final HgRepository myRepository;
    private String myErrorText;
    private static final Pattern ILLEGAL = Pattern.compile(".*:.*|[0-9]*");

    private HgReferenceValidator(HgRepository repository) {
        this.myRepository = repository;
    }

    public static HgReferenceValidator newInstance(HgRepository repository) {
        return new HgReferenceValidator(repository);
    }

    public boolean checkInput(String name) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return false;
        }
        if (ILLEGAL.matcher(name).matches()) {
            this.myErrorText = "Invalid name for branch/tag";
            return false;
        }
        return !this.isReservedWord(name) && !this.hasConflictsWithAnotherBranch(name);
    }

    public boolean canClose(String name) {
        return this.checkInput(name);
    }

    boolean isReservedWord(String name) {
        this.myErrorText = "tip".equals(name) ? String.format("The name '%s' is reserved.", name) : null;
        return this.myErrorText != null;
    }

    boolean hasConflictsWithAnotherBranch(String name) {
        Set<String> branches = this.myRepository.getBranches().keySet();
        String currentBranch = this.myRepository.getCurrentBranch();
        this.myErrorText = currentBranch.equals(name) || branches.contains(name) ? String.format("A branch with the '%s' name already exists", name) : null;
        return this.myErrorText != null;
    }

    public String getErrorText(String inputString) {
        return this.myErrorText;
    }
}

