/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.util.ObjectUtils;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.push.HgOutgoingCommitsProvider;
import org.zmlx.hg4idea.push.HgPushOptionsPanel;
import org.zmlx.hg4idea.push.HgPushSource;
import org.zmlx.hg4idea.push.HgPushTargetPanel;
import org.zmlx.hg4idea.push.HgPusher;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPushSupport
extends PushSupport<HgRepository, HgPushSource, HgTarget> {
    private final Project myProject;
    private final HgVcs myVcs;
    private final HgProjectSettings mySettings;
    private final PushSettings myCommonPushSettings;

    public HgPushSupport(Project project) {
        this.myProject = project;
        this.myVcs = (HgVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)HgVcs.getInstance(this.myProject))));
        this.mySettings = this.myVcs.getProjectSettings();
        this.myCommonPushSettings = (PushSettings)ServiceManager.getService((Project)project, PushSettings.class);
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Pusher<HgRepository, HgPushSource, HgTarget> getPusher() {
        return new HgPusher();
    }

    public OutgoingCommitsProvider<HgRepository, HgPushSource, HgTarget> getOutgoingCommitsProvider() {
        return new HgOutgoingCommitsProvider();
    }

    public HgTarget getDefaultTarget(HgRepository repository) {
        String defaultPushPath = repository.getRepositoryConfig().getDefaultPushPath();
        return defaultPushPath == null ? null : new HgTarget(defaultPushPath, repository.getCurrentBranchName());
    }

    public HgPushSource getSource(HgRepository repository) {
        String localBranch = repository.getCurrentBranchName();
        return new HgPushSource(localBranch);
    }

    public RepositoryManager<HgRepository> getRepositoryManager() {
        return HgUtil.getRepositoryManager(this.myProject);
    }

    public VcsPushOptionsPanel createOptionsPanel() {
        return new HgPushOptionsPanel();
    }

    public PushTargetPanel<HgTarget> createTargetPanel(HgRepository repository, HgTarget defaultTarget) {
        return new HgPushTargetPanel(repository, defaultTarget);
    }

    public boolean isForcePushAllowed(HgRepository repo, HgTarget target) {
        return true;
    }

    public boolean isForcePushEnabled() {
        return true;
    }

    public boolean shouldRequestIncomingChangesForNotCheckedRepositories() {
        return this.mySettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC;
    }

    public void saveSilentForcePushTarget(HgTarget target) {
        this.myCommonPushSettings.addForcePushTarget(target.getPresentation(), target.getBranchName());
    }

    public boolean isSilentForcePushAllowed(HgTarget target) {
        return this.myCommonPushSettings.containsForcePushTarget(target.getPresentation(), target.getBranchName());
    }
}

