/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.actions.VcsQuickListContentProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HgQuickListProvider
implements VcsQuickListContentProvider {
    private static final Logger LOG = Logger.getInstance((String)HgQuickListProvider.class.getName());

    public List<AnAction> getVcsActions(Project project, AbstractVcs activeVcs, DataContext dataContext) {
        if (activeVcs == null || !"hg4idea".equals(activeVcs.getName())) {
            return null;
        }
        ActionManager manager = ActionManager.getInstance();
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new Separator(activeVcs.getDisplayName()));
        actions.add((AnAction)new Separator());
        HgQuickListProvider.add("hg4idea.branches", manager, actions);
        HgQuickListProvider.add("hg4idea.pull", manager, actions);
        HgQuickListProvider.add("Vcs.Push", manager, actions);
        HgQuickListProvider.add("hg4idea.updateTo", manager, actions);
        return actions;
    }

    public List<AnAction> getNotInVcsActions(Project project, DataContext dataContext) {
        String actionName = "Hg.Init";
        AnAction action = ActionManager.getInstance().getAction("Hg.Init");
        if (action == null) {
            LOG.info("Couldn't find action for name Hg.Init");
            return null;
        }
        return Collections.singletonList(action);
    }

    public boolean replaceVcsActionsFor(AbstractVcs activeVcs, DataContext dataContext) {
        return false;
    }

    private static void add(String actionName, ActionManager manager, List<AnAction> actions) {
        AnAction action = manager.getAction(actionName);
        if (action == null) {
            LOG.info("Couldn't find action for name " + actionName);
        } else {
            actions.add(action);
        }
    }
}

