/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgFileRevisionLogParser;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgHistoryUtil {
    private static final Logger LOG = Logger.getInstance(HgHistoryUtil.class);

    private HgHistoryUtil() {
    }

    public static List<VcsCommitMetadata> loadMetadata(Project project, final VirtualFile root, int limit, List<String> parameters) throws VcsException {
        final VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return Collections.emptyList();
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        List<String> templateList = HgBaseLogParser.constructDefaultTemplate(version);
        templateList.add("{desc}");
        String[] templates = ArrayUtil.toStringArray(templateList);
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, limit, parameters, HgChangesetUtil.makeTemplate(templates));
        HgBaseLogParser<VcsCommitMetadata> baseParser = new HgBaseLogParser<VcsCommitMetadata>(){

            @Override
            protected VcsCommitMetadata convertDetails(String rev, String changeset, SmartList<HgRevisionNumber> parents, Date revisionDate, String author, String email, List<String> attributes) {
                String message = 1.parseAdditionalStringAttribute(attributes, 5);
                int subjectIndex = message.indexOf(10);
                String subject = subjectIndex == -1 ? message : message.substring(0, subjectIndex);
                SmartList parentsHash = new SmartList();
                for (HgRevisionNumber parent : parents) {
                    parentsHash.add(factory.createHash(parent.getChangeset()));
                }
                return factory.createCommitMetadata(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime(), root, subject, author, email, message, author, email, revisionDate.getTime());
            }
        };
        return HgHistoryUtil.getCommitRecords(project, result, baseParser);
    }

    public static List<? extends VcsFullCommitDetails> history(Project project, VirtualFile root, int limit, List<String> parameters) throws VcsException {
        return HgHistoryUtil.history(project, root, limit, parameters, false);
    }

    public static List<? extends VcsFullCommitDetails> history(Project project, VirtualFile root, int limit, List<String> parameters, boolean silent) throws VcsException {
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(true, version);
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, limit, parameters, HgChangesetUtil.makeTemplate(templates));
        return HgHistoryUtil.createFullCommitsFromResult(project, root, result, version, silent);
    }

    public static List<? extends VcsFullCommitDetails> createFullCommitsFromResult(Project project, VirtualFile root, HgCommandResult result, HgVersion version, boolean silent) {
        VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return Collections.emptyList();
        }
        List<HgFileRevision> hgRevisions = HgHistoryUtil.getCommitRecords(project, result, new HgFileRevisionLogParser(project, HgHistoryUtil.getOriginalHgFile(project, root), version), silent);
        ArrayList<VcsFullCommitDetails> vcsFullCommitDetailsList = new ArrayList<VcsFullCommitDetails>();
        for (HgFileRevision revision : hgRevisions) {
            HgRevisionNumber vcsRevisionNumber = revision.getRevisionNumber();
            List<HgRevisionNumber> parents = vcsRevisionNumber.getParents();
            HgRevisionNumber firstParent = parents.isEmpty() ? null : parents.get(0);
            SmartList parentsHash = new SmartList();
            for (HgRevisionNumber parent : parents) {
                parentsHash.add(factory.createHash(parent.getChangeset()));
            }
            final ArrayList<Change> changes = new ArrayList<Change>();
            for (String string : revision.getModifiedFiles()) {
                changes.add(HgHistoryUtil.createChange(project, root, string, firstParent, string, vcsRevisionNumber, FileStatus.MODIFIED));
            }
            for (String string : revision.getAddedFiles()) {
                changes.add(HgHistoryUtil.createChange(project, root, null, null, string, vcsRevisionNumber, FileStatus.ADDED));
            }
            for (String string : revision.getDeletedFiles()) {
                changes.add(HgHistoryUtil.createChange(project, root, string, firstParent, null, vcsRevisionNumber, FileStatus.DELETED));
            }
            for (Map.Entry entry : revision.getCopiedFiles().entrySet()) {
                changes.add(HgHistoryUtil.createChange(project, root, (String)entry.getKey(), firstParent, (String)entry.getValue(), vcsRevisionNumber, FileStatus.ADDED));
            }
            vcsFullCommitDetailsList.add(factory.createFullDetails(factory.createHash(vcsRevisionNumber.getChangeset()), (List)parentsHash, revision.getRevisionDate().getTime(), root, vcsRevisionNumber.getSubject(), vcsRevisionNumber.getAuthor(), vcsRevisionNumber.getEmail(), vcsRevisionNumber.getCommitMessage(), vcsRevisionNumber.getAuthor(), vcsRevisionNumber.getEmail(), revision.getRevisionDate().getTime(), (ThrowableComputable)new ThrowableComputable<Collection<Change>, Exception>(){

                public Collection<Change> compute() throws Exception {
                    return changes;
                }
            }));
        }
        return vcsFullCommitDetailsList;
    }

    private static HgCommandResult getLogResult(Project project, VirtualFile root, HgVersion version, int limit, List<String> parameters, String template) {
        HgFile originalHgFile = HgHistoryUtil.getOriginalHgFile(project, root);
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        ArrayList<String> args = new ArrayList<String>(parameters);
        hgLogCommand.setLogFile(false);
        if (!version.isParentRevisionTemplateSupported()) {
            args.add("--debug");
        }
        return hgLogCommand.execute(root, template, limit, originalHgFile, args);
    }

    public static HgFile getOriginalHgFile(Project project, VirtualFile root) {
        HgFile hgFile = new HgFile(root, VcsUtil.getFilePath((String)root.getPath()));
        if (project.isDisposed()) {
            return hgFile;
        }
        FilePath originalFileName = HgUtil.getOriginalFileName(hgFile.toFilePath(), ChangeListManager.getInstance((Project)project));
        return new HgFile(hgFile.getRepo(), originalFileName);
    }

    public static <CommitInfo> List<CommitInfo> getCommitRecords(Project project, HgCommandResult result, Function<String, CommitInfo> converter) {
        return HgHistoryUtil.getCommitRecords(project, result, converter, false);
    }

    public static <CommitInfo> List<CommitInfo> getCommitRecords(Project project, HgCommandResult result, Function<String, CommitInfo> converter, boolean silent) {
        LinkedList revisions = new LinkedList();
        if (result == null) {
            return revisions;
        }
        List<String> errors = result.getErrorLines();
        if (errors != null && !errors.isEmpty()) {
            if (result.getExitValue() != 0) {
                if (silent) {
                    LOG.debug(errors.toString());
                } else {
                    VcsNotifier.getInstance((Project)project).notifyError(HgVcsMessages.message("hg4idea.error.log.command.execution", new Object[0]), errors.toString());
                }
                return Collections.emptyList();
            }
            LOG.warn(errors.toString());
        }
        String output = result.getRawOutput();
        List changeSets = StringUtil.split((String)output, (String)"\u0003");
        return ContainerUtil.mapNotNull((Collection)changeSets, converter);
    }

    public static List<? extends VcsShortCommitDetails> readMiniDetails(Project project, final VirtualFile root, List<String> hashes) throws VcsException {
        final VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return Collections.emptyList();
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        List<String> templateList = HgBaseLogParser.constructDefaultTemplate(version);
        templateList.add("{desc}");
        String[] templates = ArrayUtil.toStringArray(templateList);
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, -1, HgHistoryUtil.prepareHashes(hashes), HgChangesetUtil.makeTemplate(templates));
        return HgHistoryUtil.getCommitRecords(project, result, new HgBaseLogParser<VcsShortCommitDetails>(){

            @Override
            protected VcsShortCommitDetails convertDetails(String rev, String changeset, SmartList<HgRevisionNumber> parents, Date revisionDate, String author, String email, List<String> attributes) {
                String message = 3.parseAdditionalStringAttribute(attributes, 5);
                int subjectIndex = message.indexOf(10);
                String subject = subjectIndex == -1 ? message : message.substring(0, subjectIndex);
                SmartList parentsHash = new SmartList();
                for (HgRevisionNumber parent : parents) {
                    parentsHash.add(factory.createHash(parent.getChangeset()));
                }
                return factory.createShortDetails(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime(), root, subject, author, email, author, email, revisionDate.getTime());
            }
        });
    }

    public static List<TimedVcsCommit> readAllHashes(Project project, VirtualFile root, final Consumer<VcsUser> userRegistry, List<String> params) throws VcsException {
        final VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return Collections.emptyList();
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = ArrayUtil.toStringArray(HgBaseLogParser.constructDefaultTemplate(version));
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, -1, params, HgChangesetUtil.makeTemplate(templates));
        return HgHistoryUtil.getCommitRecords(project, result, new HgBaseLogParser<TimedVcsCommit>(){

            @Override
            protected TimedVcsCommit convertDetails(String rev, String changeset, SmartList<HgRevisionNumber> parents, Date revisionDate, String author, String email, List<String> attributes) {
                SmartList parentsHash = new SmartList();
                for (HgRevisionNumber parent : parents) {
                    parentsHash.add(factory.createHash(parent.getChangeset()));
                }
                userRegistry.consume((Object)factory.createUser(author, email));
                return factory.createTimedCommit(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime());
            }
        });
    }

    private static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(Project project) {
        if (!project.isDisposed()) {
            return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
        }
        return null;
    }

    public static Change createChange(Project project, VirtualFile root, String fileBefore, HgRevisionNumber revisionBefore, String fileAfter, HgRevisionNumber revisionAfter, FileStatus aStatus) {
        HgContentRevision beforeRevision = fileBefore == null ? null : new HgContentRevision(project, new HgFile(root, new File(root.getPath(), fileBefore)), revisionBefore);
        HgContentRevision afterRevision = fileAfter == null ? null : new HgContentRevision(project, new HgFile(root, new File(root.getPath(), fileAfter)), revisionAfter);
        return new Change((ContentRevision)beforeRevision, (ContentRevision)afterRevision, aStatus);
    }

    public static List<String> prepareHashes(List<String> hashes) {
        ArrayList<String> hashArgs = new ArrayList<String>();
        for (String hash : hashes) {
            hashArgs.add("-r");
            hashArgs.add(hash);
        }
        return hashArgs;
    }

    public static Collection<String> getDescendingHeadsOfBranches(Project project, VirtualFile root, Hash hash) throws VcsException {
        HashSet<String> branchHeads = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        params.add("-r");
        params.add("descendants(" + hash.asString() + ") and head()");
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        String template = HgChangesetUtil.makeTemplate("{branch}", "{bookmarks}");
        HgCommandResult logResult = hgLogCommand.execute(root, template, -1, null, params);
        if (logResult == null || logResult.getExitValue() != 0) {
            throw new VcsException("Couldn't get commit details: log command execution error.");
        }
        String output = logResult.getRawOutput();
        List changeSets = StringUtil.split((String)output, (String)"\u0003");
        for (String line : changeSets) {
            List attributes = StringUtil.split((String)line, (String)"\u0017");
            branchHeads.addAll(attributes);
        }
        return branchHeads;
    }

    public static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }
}

