/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.LineHandlerHelper;
import java.io.File;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.ShellCommandException;

public final class ShellCommand {
    private final GeneralCommandLine myCommandLine;
    private int myExitCode;

    public ShellCommand(List<String> commandLine, String dir, Charset charset) {
        if (commandLine == null || commandLine.isEmpty()) {
            throw new IllegalArgumentException("commandLine is empty");
        }
        this.myCommandLine = new GeneralCommandLine(commandLine);
        if (dir != null) {
            this.myCommandLine.setWorkDirectory(new File(dir));
        }
        if (charset != null) {
            this.myCommandLine.setCharset(charset);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCommandLine.getEnvironment().put("HGRCPATH", "");
        }
    }

    public HgCommandResult execute(final boolean showTextOnIndicator) throws ShellCommandException, InterruptedException {
        final StringWriter out = new StringWriter();
        final StringWriter err = new StringWriter();
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        try {
            Process process = this.myCommandLine.createProcess();
            OSProcessHandler processHandler = new OSProcessHandler(process, this.myCommandLine.toString(), this.myCommandLine.getCharset());
            processHandler.addProcessListener(new ProcessListener(){

                public void startNotified(ProcessEvent event) {
                }

                public void processTerminated(ProcessEvent event) {
                    ShellCommand.this.myExitCode = event.getExitCode();
                }

                public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                }

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    block4: {
                        Iterator lines;
                        block3: {
                            lines = LineHandlerHelper.splitText((String)event.getText()).iterator();
                            if (ProcessOutputTypes.STDOUT != outputType) break block3;
                            while (lines.hasNext()) {
                                String line = (String)lines.next();
                                if (indicator != null && showTextOnIndicator) {
                                    indicator.setText2(line);
                                }
                                out.write(line);
                            }
                            break block4;
                        }
                        if (ProcessOutputTypes.STDERR != outputType) break block4;
                        while (lines.hasNext()) {
                            err.write((String)lines.next());
                        }
                    }
                }
            });
            processHandler.startNotify();
            while (!processHandler.waitFor(300L)) {
                if (indicator == null || !indicator.isCanceled()) continue;
                processHandler.destroyProcess();
                this.myExitCode = 255;
                break;
            }
            return new HgCommandResult(out, err, this.myExitCode);
        }
        catch (ExecutionException e) {
            throw new ShellCommandException(e);
        }
    }
}

