/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.EventQueue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgDeleteModifyPromptHandler;
import org.zmlx.hg4idea.execution.HgPromptChoice;
import org.zmlx.hg4idea.execution.HgPromptHandler;
import org.zmlx.hg4idea.execution.SocketServer;

public class HgPromptCommandExecutor
extends HgCommandExecutor {
    public HgPromptCommandExecutor(Project project) {
        super(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HgCommandResult executeInCurrentThread(VirtualFile repo, String operation, List<String> arguments) {
        SocketServer promptServer = new SocketServer(new PromptReceiver(new HgDeleteModifyPromptHandler()));
        try {
            int promptPort = promptServer.start();
            HgCommandResult hgCommandResult = super.executeInCurrentThread(repo, operation, this.prepareArguments(arguments, promptPort));
            return hgCommandResult;
        }
        catch (IOException e) {
            this.showError(e);
            LOG.info("IOException during preparing command", (Throwable)e);
            HgCommandResult hgCommandResult = null;
            return hgCommandResult;
        }
        finally {
            promptServer.stop();
        }
    }

    private List<String> prepareArguments(List<String> arguments, int port) {
        ArrayList cmdArguments = ContainerUtil.newArrayList();
        cmdArguments.add("--config");
        cmdArguments.add("extensions.hg4ideapromptextension=" + this.myVcs.getPromptHooksExtensionFile().getAbsolutePath());
        cmdArguments.add("--config");
        cmdArguments.add("hg4ideaprompt.port=" + port);
        if (arguments != null && arguments.size() != 0) {
            cmdArguments.addAll(arguments);
        }
        return cmdArguments;
    }

    private static class PromptReceiver
    extends SocketServer.Protocol {
        HgPromptHandler myHandler;

        public PromptReceiver(HgPromptHandler handler) {
            this.myHandler = handler;
        }

        @Override
        public boolean handleConnection(Socket socket) throws IOException {
            DataInputStream dataInput = new DataInputStream(socket.getInputStream());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            final String message = new String(PromptReceiver.readDataBlock(dataInput));
            int numOfChoices = dataInput.readInt();
            final HgPromptChoice[] choices = new HgPromptChoice[numOfChoices];
            for (int i = 0; i < numOfChoices; ++i) {
                String choice = new String(PromptReceiver.readDataBlock(dataInput));
                choices[i] = new HgPromptChoice(i, choice);
            }
            int defaultChoiceInt = dataInput.readInt();
            final HgPromptChoice defaultChoice = choices[defaultChoiceInt];
            if (this.myHandler != null && this.myHandler.shouldHandle(message)) {
                int chosen = this.myHandler.promptUser(message, choices, defaultChoice).getChosenIndex();
                PromptReceiver.sendChoiceToHg(out, chosen);
                return true;
            }
            final int[] index = new int[]{-1};
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String[] choicePresentationArray = new String[choices.length];
                        for (int i = 0; i < choices.length; ++i) {
                            choicePresentationArray[i] = choices[i].toString();
                        }
                        index[0] = Messages.showDialog((String)message, (String)"Mercurial Prompt Message", (String[])choicePresentationArray, (int)defaultChoice.getChosenIndex(), (Icon)Messages.getQuestionIcon());
                    }
                });
                int chosen = index[0];
                PromptReceiver.sendChoiceToHg(out, chosen);
                return true;
            }
            catch (InterruptedException e) {
                return true;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private static void sendChoiceToHg(DataOutputStream outStream, int choice) throws IOException {
            if (choice == -1) {
                outStream.writeInt(-1);
            } else {
                outStream.writeInt(choice);
            }
        }
    }
}

