/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.cherrypick;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgGraftCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCherryPicker
extends VcsCherryPicker {
    private final Project myProject;

    public HgCherryPicker(Project project) {
        this.myProject = project;
    }

    public VcsKey getSupportedVcs() {
        return HgVcs.getKey();
    }

    public String getActionTitle() {
        return "Graft";
    }

    public void cherryPick(List<VcsFullCommitDetails> commits) {
        Map commitsInRoots = DvcsUtil.groupCommitsByRoots((RepositoryManager)HgUtil.getRepositoryManager(this.myProject), commits);
        for (Map.Entry entry : commitsInRoots.entrySet()) {
            HgCherryPicker.processGrafting((HgRepository)entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), (Function)new Function<VcsFullCommitDetails, String>(){

                public String fun(VcsFullCommitDetails commitDetails) {
                    return ((Hash)commitDetails.getId()).asString();
                }
            }));
        }
    }

    private static void processGrafting(HgRepository repository, List<String> hashes) {
        boolean hasConflicts;
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        HgGraftCommand command = new HgGraftCommand(project, repository);
        HgCommandResult result = command.startGrafting(hashes);
        boolean bl = hasConflicts = !HgConflictResolver.findConflicts(project, root).isEmpty();
        if (!hasConflicts && HgErrorUtil.isCommandExecutionFailed(result)) {
            new HgCommandResultNotifier(project).notifyError(result, "Hg Error", "Couldn't  graft.");
            return;
        }
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        while (hasConflicts) {
            new HgConflictResolver(project, updatedFiles).resolve(root);
            boolean bl2 = hasConflicts = !HgConflictResolver.findConflicts(project, root).isEmpty();
            if (!hasConflicts) {
                result = command.continueGrafting();
                hasConflicts = !HgConflictResolver.findConflicts(project, root).isEmpty();
                continue;
            }
            new HgCommandResultNotifier(project).notifyError(result, "Hg Error", "Couldn't continue grafting");
            break;
        }
        repository.update();
        root.refresh(true, true);
    }

    public boolean isEnabled(VcsLog log, List<VcsFullCommitDetails> details) {
        if (details.isEmpty()) {
            return false;
        }
        for (VcsFullCommitDetails commit : details) {
            HgRepository repository = (HgRepository)HgUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(commit.getRoot());
            if (repository != null) continue;
            return false;
        }
        return true;
    }
}

