/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchUtil {
    public static List<String> getCommonBranches(Collection<HgRepository> repositories) {
        Collection<String> commonBranches = null;
        for (HgRepository repository : repositories) {
            Set<String> names = repository.getOpenedBranches();
            if (commonBranches == null) {
                commonBranches = names;
                continue;
            }
            commonBranches = ContainerUtil.intersection(commonBranches, names);
        }
        if (commonBranches != null) {
            ArrayList<String> common = new ArrayList<String>(commonBranches);
            Collections.sort(common);
            return common;
        }
        return Collections.emptyList();
    }

    public static List<String> getCommonBookmarks(Collection<HgRepository> repositories) {
        Collection<String> commonBookmarkNames = null;
        for (HgRepository repository : repositories) {
            Collection<HgNameWithHashInfo> bookmarksInfo = repository.getBookmarks();
            List<String> names = HgUtil.getNamesWithoutHashes(bookmarksInfo);
            if (commonBookmarkNames == null) {
                commonBookmarkNames = names;
                continue;
            }
            commonBookmarkNames = ContainerUtil.intersection(commonBookmarkNames, names);
        }
        if (commonBookmarkNames != null) {
            ArrayList<String> common = new ArrayList<String>(commonBookmarkNames);
            Collections.sort(common);
            return common;
        }
        return Collections.emptyList();
    }
}

