/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgInitCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.ui.HgInitAlreadyUnderHgDialog;
import org.zmlx.hg4idea.ui.HgInitDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgInit
extends DumbAwareAction {
    private Project myProject;

    public void actionPerformed(AnActionEvent e) {
        HgInitDialog hgInitDialog;
        this.myProject = (Project)e.getData(CommonDataKeys.PROJECT);
        if (this.myProject == null) {
            this.myProject = ProjectManager.getInstance().getDefaultProject();
        }
        if (!(hgInitDialog = new HgInitDialog(this.myProject)).showAndGet()) {
            return;
        }
        VirtualFile selectedRoot = hgInitDialog.getSelectedFolder();
        if (selectedRoot == null) {
            return;
        }
        VirtualFile vcsRoot = HgUtil.getNearestHgRoot(selectedRoot);
        VirtualFile mapRoot = selectedRoot;
        boolean needToCreateRepo = false;
        if (vcsRoot != null) {
            HgInitAlreadyUnderHgDialog dialog = new HgInitAlreadyUnderHgDialog(this.myProject, selectedRoot.getPresentableUrl(), vcsRoot.getPresentableUrl());
            if (!dialog.showAndGet()) {
                return;
            }
            if (dialog.getAnswer() == HgInitAlreadyUnderHgDialog.Answer.USE_PARENT_REPO) {
                mapRoot = vcsRoot;
            } else if (dialog.getAnswer() == HgInitAlreadyUnderHgDialog.Answer.CREATE_REPO_HERE) {
                needToCreateRepo = true;
            }
        } else {
            needToCreateRepo = true;
        }
        if (needToCreateRepo) {
            this.createRepository(selectedRoot, mapRoot);
        } else {
            this.updateDirectoryMappings(mapRoot);
        }
    }

    private void updateDirectoryMappings(VirtualFile mapRoot) {
        if (this.myProject != null && !this.myProject.isDefault() && this.myProject.getBaseDir() != null && VfsUtil.isAncestor((VirtualFile)this.myProject.getBaseDir(), (VirtualFile)mapRoot, (boolean)false)) {
            mapRoot.refresh(false, false);
            String path = mapRoot.equals(this.myProject.getBaseDir()) ? "" : mapRoot.getPath();
            ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)path, (String)"hg4idea"));
            manager.updateActiveVcss();
        }
    }

    private void createRepository(final VirtualFile selectedRoot, final VirtualFile mapRoot) {
        new HgInitCommand(this.myProject).execute(selectedRoot, new HgCommandResultHandler(){

            @Override
            public void process(HgCommandResult result) {
                if (!HgErrorUtil.hasErrorsInCommandExecution(result)) {
                    HgInit.this.updateDirectoryMappings(mapRoot);
                    VcsNotifier.getInstance((Project)HgInit.this.myProject).notifySuccess(HgVcsMessages.message("hg4idea.init.created.notification.title", new Object[0]), HgVcsMessages.message("hg4idea.init.created.notification.description", selectedRoot.getPresentableUrl()));
                } else {
                    new HgCommandResultNotifier(HgInit.this.myProject.isDefault() ? null : HgInit.this.myProject).notifyError(result, HgVcsMessages.message("hg4idea.init.error.title", new Object[0]), HgVcsMessages.message("hg4idea.init.error.description", selectedRoot.getPresentableUrl()));
                }
            }
        });
    }
}

