/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.google.common.base.Objects;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.util.Collections;
import java.util.List;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRevisionNumber
implements VcsRevisionNumber {
    private static final int SHORT_HASH_SIZE = 12;
    private final String revision;
    private final String changeset;
    private final String commitMessage;
    private final String author;
    private final String email;
    private final List<HgRevisionNumber> parents;
    private final String mySubject;
    private final boolean isWorkingVersion;
    public static final HgRevisionNumber NULL_REVISION_NUMBER = new HgRevisionNumber("", "", "", "", Collections.emptyList()){

        @Override
        public int compareTo(VcsRevisionNumber o) {
            return NULL.compareTo((Object)o);
        }

        @Override
        public String asString() {
            return NULL.asString();
        }
    };

    public static HgRevisionNumber getInstance(String revision, String changeset, String author, String commitMessage) {
        return new HgRevisionNumber(revision, changeset, author, commitMessage, Collections.<HgRevisionNumber>emptyList());
    }

    public static HgRevisionNumber getInstance(String revision, String changeset) {
        return new HgRevisionNumber(revision, changeset, "", "", Collections.<HgRevisionNumber>emptyList());
    }

    public static HgRevisionNumber getInstance(String revision, String changeset, List<HgRevisionNumber> parents) {
        return new HgRevisionNumber(revision, changeset, "", "", parents);
    }

    public static HgRevisionNumber getLocalInstance(String revision) {
        return new HgRevisionNumber(revision, "", "", "", Collections.<HgRevisionNumber>emptyList());
    }

    public HgRevisionNumber(String revision, String changeset, String authorInfo, String commitMessage, List<HgRevisionNumber> parents) {
        this.commitMessage = commitMessage;
        Couple<String> authorArgs = HgUtil.parseUserNameAndEmail(authorInfo);
        this.author = (String)authorArgs.getFirst();
        this.email = (String)authorArgs.getSecond();
        this.parents = parents;
        this.revision = revision.trim();
        this.changeset = changeset.trim();
        this.isWorkingVersion = changeset.endsWith("+");
        int subjectIndex = commitMessage.indexOf(10);
        this.mySubject = subjectIndex == -1 ? commitMessage : commitMessage.substring(0, subjectIndex);
    }

    public String getChangeset() {
        return this.changeset;
    }

    public String getRevision() {
        return this.revision;
    }

    public long getRevisionAsLong() {
        return Long.parseLong(this.revision);
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean isWorkingVersion() {
        return this.isWorkingVersion;
    }

    public String asString() {
        if (this.revision.isEmpty()) {
            return this.changeset;
        }
        return this.revision + ":" + this.changeset;
    }

    public List<HgRevisionNumber> getParents() {
        return this.parents;
    }

    public int compareTo(VcsRevisionNumber o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof HgRevisionNumber)) {
            return -1;
        }
        HgRevisionNumber other = (HgRevisionNumber)o;
        if (this.changeset.equals(other.changeset)) {
            return 0;
        }
        if (this.changeset.isEmpty()) {
            return 1;
        }
        if (other.changeset.isEmpty()) {
            return -1;
        }
        int revCompare = Long.valueOf(this.getRevisionNumber()).compareTo(Long.valueOf(other.getRevisionNumber()));
        if (revCompare != 0) {
            return revCompare;
        }
        if (HgRevisionNumber.getShortHash(this.changeset).equals(HgRevisionNumber.getShortHash(other.changeset))) {
            return 0;
        }
        if (this.isWorkingVersion) {
            return other.isWorkingVersion ? 0 : 1;
        }
        return other.isWorkingVersion ? -1 : 0;
    }

    private static String getShortHash(String changeset) {
        return changeset.substring(0, 12);
    }

    public String getRevisionNumber() {
        if (this.isWorkingVersion) {
            return this.revision.substring(0, this.revision.length() - 1);
        }
        return this.revision;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.revision, this.revision.isEmpty() ? this.changeset : HgRevisionNumber.getShortHash(this.changeset)});
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HgRevisionNumber)) {
            return false;
        }
        HgRevisionNumber that = (HgRevisionNumber)object;
        return this.compareTo(that) == 0;
    }

    public String toString() {
        return this.asString();
    }

    public String getSubject() {
        return this.mySubject;
    }

    public String getEmail() {
        return this.email;
    }
}

