/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.tools.idea.configurations.OverlayContainer;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.HoverOverlay;
import com.android.tools.idea.rendering.Overlay;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderedPanel;
import com.android.tools.idea.rendering.RenderedView;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.psi.xml.XmlTag;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.AndroidPlugin;

public class AndroidLayoutPreviewPanel
extends RenderedPanel {
    private TextEditor myEditor;
    private CaretModel myCaretModel;
    private CaretListener myCaretListener = new CaretAdapter(){

        public void caretPositionChanged(CaretEvent e) {
            AndroidLayoutPreviewPanel.this.updateCaret();
            if (!AndroidLayoutPreviewPanel.this.myIgnoreListener) {
                ActionBarHandler.showMenu(false, AndroidLayoutPreviewPanel.this.myContext, true);
            }
        }
    };
    private OverlayContainer myOverlayContainer;
    private boolean myIgnoreListener;
    private boolean myUseInteractiveSelector = true;

    public AndroidLayoutPreviewPanel() {
        super(true);
    }

    public void installHover(final HoverOverlay overlay) {
        Container parent = this.getPaintComponent().getParent();
        parent.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int x1 = mouseEvent.getX();
                int y1 = mouseEvent.getY();
                Component paintComponent = AndroidLayoutPreviewPanel.this.getPaintComponent();
                RenderedView leaf = null;
                Point p = AndroidLayoutPreviewPanel.this.fromScreenToModel(x1 -= paintComponent.getX(), y1 -= paintComponent.getY());
                if (p != null) {
                    leaf = AndroidLayoutPreviewPanel.this.findLeaf(p.x, p.y, true);
                }
                if (overlay.setHoveredView(leaf)) {
                    AndroidLayoutPreviewPanel.this.repaint();
                }
            }
        });
        parent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (overlay.setHoveredView(null)) {
                    AndroidLayoutPreviewPanel.this.repaint();
                }
            }
        });
    }

    @Override
    protected double getPanelHeight() {
        return this.getParent().getParent().getSize().getHeight() - 5.0;
    }

    @Override
    protected double getPanelWidth() {
        return this.getParent().getParent().getSize().getWidth() - 5.0;
    }

    @Override
    protected boolean paintRenderedImage(Component component, Graphics g, int px, int py) {
        boolean paintedImage = super.paintRenderedImage(component, g, px, py);
        if (paintedImage) {
            Overlay.paintOverlays(this.myOverlayContainer, component, g, px, py);
        }
        return paintedImage;
    }

    public void paintOverlays(Graphics g) {
        assert (AndroidPlugin.isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode());
        Overlay.paintOverlays(this.myOverlayContainer, this.getPaintComponent().getParent(), g, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void selectView(RenderedView leaf) {
        int offset;
        if (this.myEditor != null && leaf != null && leaf.tag != null && this.myUseInteractiveSelector && (offset = leaf.tag.getTextOffset()) != -1) {
            Editor editor = this.myEditor.getEditor();
            this.myIgnoreListener = true;
            try {
                if (leaf != null) {
                    this.setSelectedViews(Collections.singletonList(leaf));
                }
                editor.getCaretModel().moveToOffset(offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }
            finally {
                this.myIgnoreListener = false;
            }
        }
    }

    private void updateCaret() {
        int offset;
        RenderedViewHierarchy hierarchy;
        if (this.myCaretModel != null && !this.myIgnoreListener && this.myUseInteractiveSelector && (hierarchy = this.myRenderResult.getHierarchy()) != null && (offset = this.myCaretModel.getOffset()) != -1) {
            List<RenderedView> views = hierarchy.findByOffset(offset);
            if (views != null && views.size() == 1 && views.get(0).isRoot()) {
                views = null;
            }
            this.setSelectedViews(views);
        }
    }

    public void setRenderResult(RenderResult renderResult, TextEditor editor) {
        super.setRenderResult(renderResult);
        this.setEditor(editor);
        this.updateCaret();
        this.doRevalidate();
    }

    private void setEditor(TextEditor editor) {
        if (editor != this.myEditor) {
            this.myEditor = editor;
            if (this.myCaretModel != null) {
                this.myCaretModel.removeCaretListener(this.myCaretListener);
                this.myCaretModel = null;
            }
            if (editor != null) {
                this.myCaretModel = this.myEditor.getEditor().getCaretModel();
                this.myCaretModel.addCaretListener(this.myCaretListener);
            }
        }
    }

    public void setOverlayContainer(OverlayContainer overlayContainer) {
        this.myOverlayContainer = overlayContainer;
    }

    public boolean isSelected(XmlTag tag) {
        if (this.mySelectedViews != null) {
            for (RenderedView view : this.mySelectedViews) {
                if (view.tag != tag) continue;
                return true;
            }
        }
        return false;
    }

    public void setUseInteractiveSelector(boolean useInteractiveSelector) {
        this.myUseInteractiveSelector = useInteractiveSelector;
    }
}

