/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.android.dom.resources.ResourceNameConverter;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;

class AndroidInlineAllStyleUsagesProcessor
extends BaseRefactoringProcessor {
    private final PsiElement myStyleElement;
    private final String myStyleName;
    private final Map<AndroidAttributeInfo, String> myAttributeValues;
    private final StyleRefData myParentStyleRef;
    private final XmlTag myStyleTag;
    private final AndroidInlineTestConfig myTestConfig;

    protected AndroidInlineAllStyleUsagesProcessor(Project project, PsiElement styleElement, XmlTag styleTag, String styleName, Map<AndroidAttributeInfo, String> attributeValues, StyleRefData parentStyleRef, AndroidInlineTestConfig config) {
        super(project);
        this.myStyleElement = styleElement;
        this.myStyleTag = styleTag;
        this.myStyleName = styleName;
        this.myAttributeValues = attributeValues;
        this.myParentStyleRef = parentStyleRef;
        this.myTestConfig = config;
    }

    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new UsageViewDescriptorAdapter(){

            public PsiElement[] getElements() {
                return new PsiElement[]{AndroidInlineAllStyleUsagesProcessor.this.myStyleElement};
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "References to be inlined" + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            public String getProcessedElementsHeader() {
                return "Style to inline";
            }
        };
    }

    protected UsageInfo[] findUsages() {
        HashSet usages = new HashSet();
        AndroidInlineUtil.addReferences(this.myStyleElement, (Collection<UsageInfo>)usages);
        for (PsiField field : AndroidResourceUtil.findResourceFieldsForValueResource(this.myStyleTag, false)) {
            AndroidInlineUtil.addReferences((PsiElement)field, (Collection<UsageInfo>)usages);
        }
        return usages.toArray(new UsageInfo[usages.size()]);
    }

    protected void performRefactoring(UsageInfo[] usages) {
        ArrayList<StyleUsageData> inlineInfos = new ArrayList<StyleUsageData>();
        for (UsageInfo usage : usages) {
            StyleUsageData usageData;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            StyleUsageData styleUsageData = usageData = tag != null ? AndroidInlineUtil.getStyleUsageData(tag) : null;
            if (usageData == null || usageData.getReference().computeTargetElements().length != 1) continue;
            inlineInfos.add(usageData);
        }
        for (StyleUsageData info : inlineInfos) {
            info.inline(this.myAttributeValues, this.myParentStyleRef);
        }
        this.myStyleTag.delete();
    }

    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap<PsiElement, String> conflicts = AndroidInlineAllStyleUsagesProcessor.detectConflicts(usages);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myTestConfig.setConflicts(conflicts);
            return true;
        }
        return this.showConflicts(conflicts, usages);
    }

    private static MultiMap<PsiElement, String> detectConflicts(UsageInfo[] usages) {
        ArrayList<PsiElement> nonXmlUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> unsupportedUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> unambiguousUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> implicitlyInherited = new ArrayList<PsiElement>();
        for (UsageInfo usage : usages) {
            StyleUsageData usageData;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            if (element.getLanguage() != XMLLanguage.INSTANCE) {
                nonXmlUsages.add(element);
                continue;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            StyleUsageData styleUsageData = usageData = tag != null ? AndroidInlineUtil.getStyleUsageData(tag) : null;
            if (usageData == null) {
                if (usage.getReference() instanceof ResourceNameConverter.MyParentStyleReference) {
                    implicitlyInherited.add(element);
                    continue;
                }
                unsupportedUsages.add(element);
                continue;
            }
            if (usageData.getReference().computeTargetElements().length <= 1) continue;
            unambiguousUsages.add(element);
        }
        return AndroidInlineUtil.buildConflicts(nonXmlUsages, unambiguousUsages, unsupportedUsages, implicitlyInherited);
    }

    protected String getCommandName() {
        return AndroidBundle.message("android.inline.style.command.name", this.myStyleName);
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
    }
}

