/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.android.tools.idea.run.TargetSelectionMode;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.util.ArrayUtil;
import javax.swing.JComponent;
import org.jetbrains.android.newProject.AndroidModifiedSettingsStep;
import org.jetbrains.android.newProject.AndroidModuleBuilder;
import org.jetbrains.android.util.AndroidBundle;

public class AndroidApplicationModifiedSettingsStep
extends AndroidModifiedSettingsStep {
    private final ComboBox myTargetDeviceCombo;
    private static final String TARGET_DO_NOT_CREATE_RUN_CONF = AndroidBundle.message("deployment.target.settings.wizard.configure.later", new Object[0]);
    private static final String TARGET_SHOW_CHOOSER_DIALOG = AndroidBundle.message("deployment.target.settings.wizard.show.dialog", new Object[0]);
    private static final String TARGET_USB_DEVICE = AndroidBundle.message("deployment.target.settings.wizard.usb.device", new Object[0]);
    private static final String TARGET_EMULATOR = AndroidBundle.message("deployment.target.settings.wizard.emulator", new Object[0]);
    private static final String TARGET_SELECTION_MODE_FOR_NEW_MODULE_PROPERTY = "ANDROID_TARGET_SELECTION_MODE_FOR_NEW_MODULE";

    AndroidApplicationModifiedSettingsStep(AndroidModuleBuilder builder, SettingsStep settingsStep) {
        super(builder, settingsStep);
        String applicationName = builder.getApplicationName();
        if (applicationName != null && applicationName.length() > 0) {
            settingsStep.getModuleNameField().setText(applicationName);
        }
        Object[] items = new String[]{TARGET_DO_NOT_CREATE_RUN_CONF, TARGET_SHOW_CHOOSER_DIALOG, TARGET_USB_DEVICE, TARGET_EMULATOR};
        this.myTargetDeviceCombo = new ComboBox(items);
        settingsStep.addSettingsField("\u001bTarget device: ", (JComponent)this.myTargetDeviceCombo);
        String prevTargetMode = PropertiesComponent.getInstance().getValue(TARGET_SELECTION_MODE_FOR_NEW_MODULE_PROPERTY);
        this.myTargetDeviceCombo.setSelectedItem((Object)(prevTargetMode != null && ArrayUtil.contains((String)prevTargetMode, (String[])items) ? prevTargetMode : TARGET_SHOW_CHOOSER_DIALOG));
    }

    @Override
    public void updateDataModel() {
        super.updateDataModel();
        TargetSelectionMode targetSelectionMode = null;
        Object selectedItem = this.myTargetDeviceCombo.getSelectedItem();
        if (TARGET_EMULATOR.equals(selectedItem)) {
            targetSelectionMode = TargetSelectionMode.EMULATOR;
        } else if (TARGET_SHOW_CHOOSER_DIALOG.equals(selectedItem)) {
            targetSelectionMode = TargetSelectionMode.SHOW_DIALOG;
        } else if (TARGET_USB_DEVICE.equals(selectedItem)) {
            targetSelectionMode = TargetSelectionMode.USB_DEVICE;
        }
        this.myBuilder.setTargetSelectionMode(targetSelectionMode);
        if (selectedItem != null) {
            PropertiesComponent.getInstance().setValue(TARGET_SELECTION_MODE_FOR_NEW_MODULE_PROPERTY, selectedItem.toString());
        }
    }
}

