/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.psi.SearchUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidResourceUtil;

class MigrateDrawableToMipmapFix
implements AndroidLintQuickFix {
    private final ResourceUrl myUrl;

    MigrateDrawableToMipmapFix(ResourceUrl url) {
        this.myUrl = url;
    }

    @Override
    public void apply(PsiElement startElement, PsiElement endElement, AndroidQuickfixContexts.Context context) {
        PsiField[] resourceFields;
        Project project = startElement.getProject();
        AndroidFacet facet = AndroidFacet.getInstance(startElement);
        if (facet == null) {
            return;
        }
        final ArrayList bitmaps = Lists.newArrayList();
        final HashSet references = Sets.newHashSet();
        GlobalSearchScope useScope = GlobalSearchScope.projectScope((Project)project);
        ProjectResourceRepository projectResources = facet.getProjectResources(true);
        List resourceItems = projectResources.getResourceItem(this.myUrl.type, this.myUrl.name);
        if (resourceItems != null) {
            for (ResourceItem item : resourceItems) {
                PsiFile file = LocalResourceRepository.getItemPsiFile(project, item);
                if (file == null) continue;
                bitmaps.add(file);
                Iterable allReferences = SearchUtils.findAllReferences((PsiElement)file, (SearchScope)useScope);
                for (PsiReference next : allReferences) {
                    PsiElement element = next.getElement();
                    if (element == null) continue;
                    references.add(element);
                }
            }
        }
        if ((resourceFields = AndroidResourceUtil.findResourceFields(facet, ResourceType.DRAWABLE.getName(), this.myUrl.name, true)).length == 1) {
            Iterable allReferences = SearchUtils.findAllReferences((PsiElement)resourceFields[0], (SearchScope)useScope);
            for (PsiReference next : allReferences) {
                PsiElement element = next.getElement();
                if (element == null) continue;
                references.add(element);
            }
        }
        HashSet applicableFiles = Sets.newHashSet();
        applicableFiles.addAll(bitmaps);
        for (PsiElement element : references) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) continue;
            applicableFiles.add(containingFile);
        }
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(project, "Migrate Drawable to Bitmap", applicableFiles.toArray(new PsiFile[applicableFiles.size()])){

            protected void run(Result<Void> result) throws Throwable {
                for (PsiFile bitmap : bitmaps) {
                    FolderConfiguration configuration;
                    VirtualFile parent;
                    VirtualFile file = bitmap.getVirtualFile();
                    if (file == null || (parent = file.getParent()) == null) continue;
                    if (file.getFileType() == StdFileTypes.XML && parent.getName().startsWith("values")) {
                        XmlFile xmlFile = (XmlFile)bitmap;
                        XmlTag root = xmlFile.getRootTag();
                        if (root == null) continue;
                        for (XmlTag item : root.getSubTags()) {
                            String name = item.getAttributeValue("name");
                            if (!((MigrateDrawableToMipmapFix)MigrateDrawableToMipmapFix.this).myUrl.name.equals(name)) continue;
                            if (ResourceType.DRAWABLE.getName().equals(item.getName())) {
                                item.setName(ResourceType.MIPMAP.getName());
                                continue;
                            }
                            if (!ResourceType.DRAWABLE.getName().equals(item.getAttributeValue("type"))) continue;
                            item.setAttribute("type", ResourceType.MIPMAP.getName());
                        }
                        continue;
                    }
                    VirtualFile res = parent.getParent();
                    if (res == null || (configuration = FolderConfiguration.getConfigForFolder((String)parent.getName())) == null) continue;
                    String targetFolderName = configuration.getFolderName(ResourceFolderType.MIPMAP);
                    VirtualFile targetFolder = res.findChild(targetFolderName);
                    if (targetFolder == null) {
                        targetFolder = res.createChildDirectory((Object)this, targetFolderName);
                    }
                    file.move((Object)this, targetFolder);
                }
                for (PsiElement reference : references) {
                    PsiReferenceExpression outer;
                    PsiReferenceExpression inner;
                    PsiExpression qualifier;
                    if (reference instanceof XmlAttributeValue) {
                        XmlAttributeValue value = (XmlAttributeValue)reference;
                        XmlAttribute attribute = (XmlAttribute)value.getParent();
                        attribute.setValue(ResourceUrl.create((ResourceType)ResourceType.MIPMAP, (String)((MigrateDrawableToMipmapFix)MigrateDrawableToMipmapFix.this).myUrl.name, (boolean)false, (boolean)false).toString());
                        continue;
                    }
                    if (!(reference instanceof PsiReferenceExpression) || !((qualifier = (inner = (PsiReferenceExpression)reference).getQualifierExpression()) instanceof PsiReferenceExpression) || !((outer = (PsiReferenceExpression)qualifier).getReferenceNameElement() instanceof PsiIdentifier)) continue;
                    PsiIdentifier identifier = (PsiIdentifier)outer.getReferenceNameElement();
                    if (!ResourceType.DRAWABLE.getName().equals(identifier.getText())) continue;
                    Project project = reference.getProject();
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                    PsiIdentifier newIdentifier = elementFactory.createIdentifier(ResourceType.MIPMAP.getName());
                    identifier.replace((PsiElement)newIdentifier);
                }
            }
        };
        action.execute();
    }

    @Override
    public boolean isApplicable(PsiElement startElement, PsiElement endElement, AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }

    @Override
    public String getName() {
        return "Convert " + this.myUrl + " to @mipmap/" + this.myUrl.name;
    }
}

