/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.sdklib.SdkVersionInfo;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfSurrounder;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;

class AddTargetVersionCheckQuickFix
implements AndroidLintQuickFix {
    private int myApi;

    AddTargetVersionCheckQuickFix(int api) {
        this.myApi = api;
    }

    static String getVersionField(int myApi, boolean fullyQualified) {
        String codeName = SdkVersionInfo.getBuildCode((int)myApi);
        if (codeName == null) {
            return Integer.toString(myApi);
        }
        if (fullyQualified) {
            return "android.os.Build.VERSION_CODES." + codeName;
        }
        return codeName;
    }

    @Override
    public String getName() {
        return "Surround with if (VERSION.SDK_INT >= VERSION_CODES." + AddTargetVersionCheckQuickFix.getVersionField(this.myApi, false) + ") { ... }";
    }

    @Override
    public boolean isApplicable(PsiElement startElement, PsiElement endElement, AndroidQuickfixContexts.ContextType contextType) {
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiExpression.class, (boolean)false);
        return expression != null;
    }

    @Override
    public void apply(PsiElement startElement, PsiElement endElement, AndroidQuickfixContexts.Context context) {
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiExpression.class, (boolean)false);
        if (expression == null) {
            return;
        }
        PsiStatement anchorStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class);
        Editor editor = PsiUtilBase.findEditor((PsiElement)expression);
        if (editor == null) {
            return;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiModifierListOwner.class, (boolean)false);
        PsiFile file = expression.getContainingFile();
        Project project = expression.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file);
        if (document == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{anchorStatement};
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)anchorStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prev instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)prev) != null) {
            elements = new PsiElement[]{prev, anchorStatement};
        }
        try {
            TextRange textRange = new JavaWithIfSurrounder().surroundElements(project, editor, elements);
            if (textRange == null) {
                return;
            }
            String newText = "android.os.Build.VERSION.SDK_INT >= " + AddTargetVersionCheckQuickFix.getVersionField(this.myApi, true);
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newText);
            documentManager.commitDocument(document);
            editor.getCaretModel().moveToOffset(textRange.getEndOffset() + newText.length());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (owner != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)owner);
            }
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance(AddTargetVersionCheckQuickFix.class).error((Throwable)e);
        }
    }
}

