/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.dom.resources.ResourcesDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidLayoutPreviewToolWindowManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;

public class CreateValueResourceQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    private final AndroidFacet myFacet;
    private final ResourceType myResourceType;
    private final String myResourceName;
    private final PsiFile myFile;
    private final boolean myChooseName;

    public CreateValueResourceQuickFix(AndroidFacet facet, ResourceType resourceType, String resourceName, PsiFile file, boolean chooseName) {
        this.myFacet = facet;
        this.myResourceType = resourceType;
        this.myResourceName = resourceName;
        this.myFile = file;
        this.myChooseName = chooseName;
    }

    public String getName() {
        return AndroidBundle.message("create.value.resource.quickfix.name", this.myResourceName, AndroidResourceUtil.getDefaultResourceFileName(this.myResourceType));
    }

    public String getText() {
        return AndroidBundle.message("create.value.resource.intention.name", this.myResourceType, this.myResourceName);
    }

    public String getFamilyName() {
        return AndroidBundle.message("quick.fixes.family", new Object[0]);
    }

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        return true;
    }

    public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.doInvoke();
    }

    protected boolean doInvoke() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String fileName = AndroidResourceUtil.getDefaultResourceFileName(this.myResourceType);
            assert (fileName != null);
            if (!AndroidResourceUtil.createValueResource(this.myFacet.getModule(), this.myResourceName, this.myResourceType, fileName, Collections.singletonList("values"), "a")) {
                return false;
            }
        } else {
            VirtualFile defaultFile;
            DomFileDescription description;
            String value = this.myResourceType == ResourceType.STYLEABLE || this.myResourceType == ResourceType.ATTR ? "\n" : null;
            VirtualFile defaultFileToCreate = null;
            if (this.myFile instanceof XmlFile && this.myFile.isWritable() && this.myFile.getManager().isInProject((PsiElement)this.myFile) && (description = DomManager.getDomManager((Project)this.myFile.getProject()).getDomFileDescription((XmlFile)this.myFile)) instanceof ResourcesDomFileDescription && (defaultFile = this.myFile.getVirtualFile()) != null) {
                defaultFileToCreate = defaultFile;
            }
            CreateXmlResourceDialog dialog = new CreateXmlResourceDialog(this.myFacet.getModule(), this.myResourceType, this.myResourceName, value, this.myChooseName, defaultFileToCreate);
            dialog.setTitle("New " + StringUtil.capitalize((String)this.myResourceType.getDisplayName()) + " Value Resource");
            if (!dialog.showAndGet()) {
                return false;
            }
            Module moduleToPlaceResource = dialog.getModule();
            if (moduleToPlaceResource == null) {
                return false;
            }
            String fileName = dialog.getFileName();
            List<String> dirNames = dialog.getDirNames();
            String resValue = dialog.getValue();
            String resName = dialog.getResourceName();
            if (!AndroidResourceUtil.createValueResource(moduleToPlaceResource, resName, this.myResourceType, fileName, dirNames, resValue)) {
                return false;
            }
        }
        Project project = this.myFile.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UndoUtil.markPsiFileForUndo((PsiFile)this.myFile);
        AndroidLayoutPreviewToolWindowManager.renderIfApplicable(project);
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(Project project, ProblemDescriptor descriptor) {
    }
}

