/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomFileDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.AndroidAnyAttributeDescriptor;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.AndroidXmlTagDescriptor;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;

public class AndroidUnknownAttributeInspection
extends LocalInspectionTool {
    private static volatile Set<String> ourSupportedResourceTypes;

    public String getGroupDisplayName() {
        return AndroidBundle.message("android.inspections.group.name", new Object[0]);
    }

    public String getDisplayName() {
        return AndroidBundle.message("android.inspections.unknown.attribute.name", new Object[0]);
    }

    public String getShortName() {
        return "AndroidUnknownAttribute";
    }

    public ProblemDescriptor[] checkFile(PsiFile file, InspectionManager manager, boolean isOnTheFly) {
        if (!(file instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (AndroidUnknownAttributeInspection.isMyFile(facet, (XmlFile)file)) {
            MyVisitor visitor = new MyVisitor(manager, isOnTheFly);
            file.accept((PsiElementVisitor)visitor);
            return visitor.myResult.toArray(new ProblemDescriptor[visitor.myResult.size()]);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    static boolean isMyFile(AndroidFacet facet, XmlFile file) {
        String resourceType = facet.getLocalResourceManager().getFileResourceType((PsiFile)file);
        if (resourceType != null) {
            if (ourSupportedResourceTypes == null) {
                ourSupportedResourceTypes = new HashSet();
                for (DomFileDescription description : (DomFileDescription[])DomFileDescription.EP_NAME.getExtensions()) {
                    if (!(description instanceof AndroidResourceDomFileDescription)) continue;
                    String[] resourceTypes = ((AndroidResourceDomFileDescription)description).getResourceTypes();
                    Collections.addAll(ourSupportedResourceTypes, resourceTypes);
                }
            }
            if (!ourSupportedResourceTypes.contains(resourceType)) {
                return false;
            }
            if (ResourceType.XML.getName().equals(resourceType)) {
                XmlTag rootTag = file.getRootTag();
                return rootTag != null && AndroidXmlResourcesUtil.isSupportedRootTag(facet, rootTag.getName());
            }
            return true;
        }
        return ManifestDomFileDescription.isManifestFile(file, facet);
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        final List<ProblemDescriptor> myResult = new ArrayList<ProblemDescriptor>();

        private MyVisitor(InspectionManager inspectionManager, boolean onTheFly) {
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            XmlTag tag;
            String namespace;
            if (!"xmlns".equals(attribute.getNamespacePrefix()) && ("http://schemas.android.com/apk/res/android".equals(namespace = attribute.getNamespace()) || namespace.isEmpty()) && (tag = attribute.getParent()) != null && tag.getDescriptor() instanceof AndroidXmlTagDescriptor && attribute.getDescriptor() instanceof AndroidAnyAttributeDescriptor) {
                PsiElement nameElement;
                ASTNode node = attribute.getNode();
                assert (node != null);
                ASTNode nameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
                PsiElement psiElement = nameElement = nameNode != null ? nameNode.getPsi() : null;
                if (nameElement != null) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor(nameElement, AndroidBundle.message("android.inspections.unknown.attribute.message", attribute.getName()), this.myOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
            }
        }
    }
}

