/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.intellij.codeInsight.daemon.impl.quickfix.ConvertSwitchToIfIntention;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.switchtoif.ReplaceSwitchWithIfIntention;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;

public class AndroidNonConstantResIdsInSwitchInspection
extends LocalInspectionTool {
    private final ReplaceSwitchWithIfIntention myBaseIntention = new ReplaceSwitchWithIfIntention();

    public String getGroupDisplayName() {
        return AndroidBundle.message("android.inspections.group.name", new Object[0]);
    }

    public String getDisplayName() {
        return AndroidBundle.message("android.inspections.non.constant.res.ids.in.switch.name", new Object[0]);
    }

    public String getShortName() {
        return "AndroidNonConstantResIdsInSwitch";
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
                AndroidFacet facet = AndroidFacet.getInstance((PsiElement)statement);
                if (facet == null || !facet.isLibraryProject()) {
                    return;
                }
                PsiExpression caseValue = statement.getCaseValue();
                if (!(caseValue instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiSwitchStatement.class);
                if (switchStatement == null || !ReplaceSwitchWithIfIntention.canProcess((PsiSwitchStatement)switchStatement)) {
                    return;
                }
                PsiElement resolvedElement = ((PsiReferenceExpression)caseValue).resolve();
                if (resolvedElement == null || !(resolvedElement instanceof PsiField)) {
                    return;
                }
                PsiField resolvedField = (PsiField)resolvedElement;
                if (!AndroidResourceUtil.isResourceField(resolvedField)) {
                    return;
                }
                PsiModifierList modifierList = resolvedField.getModifierList();
                if (modifierList == null || !modifierList.hasModifierProperty("final")) {
                    holder.registerProblem((PsiElement)caseValue, AndroidBundle.message("android.inspections.non.constant.res.ids.in.switch.message", new Object[0]), new LocalQuickFix[]{new MyQuickFix()});
                }
            }
        };
    }

    public String getQuickFixName() {
        return this.myBaseIntention.getText();
    }

    private class MyQuickFix
    implements LocalQuickFix {
        private MyQuickFix() {
        }

        public String getName() {
            return AndroidNonConstantResIdsInSwitchInspection.this.getQuickFixName();
        }

        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element == null) {
                return;
            }
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiSwitchStatement.class);
            if (switchStatement == null) {
                return;
            }
            ConvertSwitchToIfIntention.doProcessIntention((PsiSwitchStatement)switchStatement);
        }
    }
}

