/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.AndroidGotoRelatedProvider;
import org.jetbrains.android.dom.AndroidCreateOnClickHandlerAction;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.menu.MenuDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;

public class AndroidMissingOnClickHandlerInspection
extends LocalInspectionTool {
    private static Collection<PsiClass> findRelatedActivities(XmlFile file, AndroidFacet facet, DomFileDescription<?> description) {
        if (description instanceof LayoutDomFileDescription) {
            Computable<List<GotoRelatedItem>> computable = AndroidGotoRelatedProvider.getLazyItemsForXmlFile(file, facet);
            if (computable == null) {
                return Collections.emptyList();
            }
            List items = (List)computable.compute();
            if (items.isEmpty()) {
                return Collections.emptyList();
            }
            PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(facet.getModule());
            if (activityClass == null) {
                return Collections.emptyList();
            }
            ArrayList<PsiClass> result = new ArrayList<PsiClass>();
            for (GotoRelatedItem item : items) {
                PsiClass aClass;
                PsiElement element = item.getElement();
                if (!(element instanceof PsiClass) || !(aClass = (PsiClass)element).isInheritor(activityClass, true)) continue;
                result.add(aClass);
            }
            return result;
        }
        return AndroidMissingOnClickHandlerInspection.findRelatedActivitiesForMenu(file, facet);
    }

    private static Set<PsiClass> findRelatedActivitiesForMenu(XmlFile file, AndroidFacet facet) {
        String resourceName;
        String resType = ResourceType.MENU.getName();
        PsiField[] fields = AndroidResourceUtil.findResourceFields(facet, resType, resourceName = AndroidCommonUtils.getResourceName((String)resType, (String)file.getName()), true);
        if (fields.length == 0) {
            return Collections.emptySet();
        }
        Module module = facet.getModule();
        GlobalSearchScope scope = module.getModuleScope(false);
        PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(module);
        if (activityClass == null) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        ReferencesSearch.search((PsiElement)fields[0], (SearchScope)scope).forEach((Processor)new Processor<PsiReference>((Set)result, activityClass){
            final /* synthetic */ Set val$result;
            final /* synthetic */ PsiClass val$activityClass;
            {
                this.val$result = set;
                this.val$activityClass = psiClass;
            }

            public boolean process(PsiReference reference) {
                PsiElement element = reference.getElement();
                if (element == null) {
                    return true;
                }
                PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                if (aClass != null && !this.val$result.contains(aClass) && aClass.isInheritor(this.val$activityClass, true)) {
                    this.val$result.add(aClass);
                }
                return true;
            }
        });
        return result;
    }

    public static PsiClass findActivityClass(Module module) {
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("android.app.Activity", module.getModuleWithDependenciesAndLibrariesScope(false));
    }

    public ProblemDescriptor[] checkFile(PsiFile file, InspectionManager manager, boolean isOnTheFly) {
        if (!(file instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DomFileDescription description = DomManager.getDomManager((Project)file.getProject()).getDomFileDescription((XmlFile)file);
        if (!(description instanceof LayoutDomFileDescription) && !(description instanceof MenuDomFileDescription)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Collection<PsiClass> activities = AndroidMissingOnClickHandlerInspection.findRelatedActivities((XmlFile)file, facet, description);
        MyVisitor visitor = new MyVisitor(manager, isOnTheFly, activities);
        file.accept((PsiElementVisitor)visitor);
        return visitor.myResult.toArray(new ProblemDescriptor[visitor.myResult.size()]);
    }

    public static class MyQuickFix
    extends AbstractIntentionAction
    implements LocalQuickFix {
        private final String myMethodName;
        private final OnClickConverter myConverter;
        private final PsiClass myClass;

        private MyQuickFix(String methodName, OnClickConverter converter, PsiClass aClass) {
            this.myMethodName = methodName;
            this.myConverter = converter;
            this.myClass = aClass;
        }

        public String getName() {
            return "Create '" + this.myMethodName + "(" + this.myConverter.getShortParameterName() + ")' in '" + this.myClass.getName() + "'";
        }

        public String getText() {
            return this.getName();
        }

        public String getFamilyName() {
            return this.getName();
        }

        public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethodAndNavigate(project, this.myClass, this.myMethodName, paramType);
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            this.doApplyFix(project);
        }

        public void doApplyFix(Project project) {
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethod(project, this.myClass, this.myMethodName, paramType);
        }
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        private final Collection<PsiClass> myRelatedActivities;
        final List<ProblemDescriptor> myResult = new ArrayList<ProblemDescriptor>();

        private MyVisitor(InspectionManager inspectionManager, boolean onTheFly, Collection<PsiClass> relatedActivities) {
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
            this.myRelatedActivities = relatedActivities;
        }

        public void visitXmlAttributeValue(XmlAttributeValue value) {
            for (PsiReference reference : value.getReferences()) {
                OnClickConverter.MyReference ref;
                String methodName;
                if (!(reference instanceof OnClickConverter.MyReference) || (methodName = (ref = (OnClickConverter.MyReference)reference).getValue()).isEmpty()) continue;
                ResolveResult[] results = ref.multiResolve(false);
                HashSet resolvedClasses = new HashSet();
                HashSet resolvedClassesWithMistake = new HashSet();
                for (ResolveResult result : results) {
                    PsiClass aClass;
                    PsiElement element;
                    if (!(result instanceof OnClickConverter.MyResolveResult) || (element = result.getElement()) == null || (aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) == null) continue;
                    resolvedClasses.add(aClass);
                    if (((OnClickConverter.MyResolveResult)result).hasCorrectSignature()) continue;
                    resolvedClassesWithMistake.add(aClass);
                }
                PsiClass activity = null;
                for (PsiClass relatedActivity : this.myRelatedActivities) {
                    if (!MyVisitor.containsOrExtends((Set<PsiClass>)resolvedClasses, relatedActivity)) {
                        activity = relatedActivity;
                        break;
                    }
                    if (activity != null || !MyVisitor.containsOrExtends((Set<PsiClass>)resolvedClassesWithMistake, relatedActivity)) continue;
                    activity = relatedActivity;
                }
                if (activity != null) {
                    this.reportMissingOnClickProblem(ref, activity, methodName, resolvedClassesWithMistake.contains(activity));
                    continue;
                }
                if (results.length == 0) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)value, reference.getRangeInElement(), ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]));
                    continue;
                }
                if (resolvedClassesWithMistake.size() <= 0) continue;
                this.reportMissingOnClickProblem(ref, (PsiClass)resolvedClassesWithMistake.iterator().next(), methodName, true);
            }
        }

        private static boolean containsOrExtends(Set<PsiClass> resolvedClasses, PsiClass relatedActivity) {
            if (resolvedClasses.contains(relatedActivity)) {
                return true;
            }
            for (PsiClass resolvedClass : resolvedClasses) {
                if (!relatedActivity.isInheritor(resolvedClass, false)) continue;
                return true;
            }
            return false;
        }

        private void reportMissingOnClickProblem(OnClickConverter.MyReference reference, PsiClass activity, String methodName, boolean incorrectSignature) {
            LocalQuickFix[] localQuickFixArray;
            String message;
            String activityName = activity.getName();
            if (activityName == null) {
                activityName = "";
            }
            String string = message = incorrectSignature ? AndroidBundle.message("android.inspections.on.click.missing.incorrect.signature", methodName, activityName) : AndroidBundle.message("android.inspections.on.click.missing.problem", methodName, activityName);
            if (StringUtil.isJavaIdentifier((String)methodName)) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new MyQuickFix(methodName, reference.getConverter(), activity);
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.myResult.add(this.myInspectionManager.createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, fixes));
        }
    }
}

