/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.hash.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class ResourceFolderManager
implements ModificationTracker {
    private final AndroidFacet myFacet;
    private List<VirtualFile> myResDirCache;
    private long myGeneration;
    private final List<ResourceFolderListener> myListeners = Lists.newArrayList();
    private boolean myVariantListenerAdded;
    private boolean myGradleInitListenerAdded;

    ResourceFolderManager(AndroidFacet facet) {
        this.myFacet = facet;
    }

    public void invalidate() {
        List<VirtualFile> old = this.myResDirCache;
        this.myResDirCache = null;
        this.getFolders();
        if (!((Object)old).equals(this.myResDirCache)) {
            this.notifyChanged(old, this.myResDirCache);
        }
    }

    public List<VirtualFile> getFolders() {
        if (this.myResDirCache == null) {
            this.myResDirCache = this.computeFolders();
        }
        return this.myResDirCache;
    }

    private List<VirtualFile> computeFolders() {
        if (this.myFacet.requiresAndroidModel()) {
            JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getState();
            AndroidModel androidModel = this.myFacet.getAndroidModel();
            ArrayList<VirtualFile> resDirectories = new ArrayList<VirtualFile>();
            if (androidModel == null) {
                if (state != null) {
                    String path = state.RES_FOLDERS_RELATIVE_PATH;
                    if (path != null) {
                        VirtualFileManager manager = VirtualFileManager.getInstance();
                        for (String url : Splitter.on((char)';').omitEmptyStrings().trimResults().split((CharSequence)path)) {
                            VirtualFile dir = manager.findFileByUrl(url);
                            if (dir == null) continue;
                            resDirectories.add(dir);
                        }
                    } else {
                        String mainRes = "/src/main/res";
                        VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(this.myFacet.getModule(), mainRes, true);
                        if (dir != null) {
                            resDirectories.add(dir);
                        } else {
                            String res = "/res";
                            dir = AndroidRootUtil.getFileByRelativeModulePath(this.myFacet.getModule(), res, true);
                            if (dir != null) {
                                resDirectories.add(dir);
                            }
                        }
                    }
                }
            } else {
                for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(this.myFacet)) {
                    resDirectories.addAll(provider.getResDirectories());
                }
                if (state != null) {
                    StringBuilder path = new StringBuilder(400);
                    for (VirtualFile dir : resDirectories) {
                        if (path.length() != 0) {
                            path.append(';');
                        }
                        path.append(dir.getUrl());
                    }
                    state.RES_FOLDERS_RELATIVE_PATH = path.toString();
                }
                if (!this.myVariantListenerAdded) {
                    this.myVariantListenerAdded = true;
                    BuildVariantView.getInstance(this.myFacet.getModule().getProject()).addListener(new BuildVariantView.BuildVariantSelectionChangeListener(){

                        @Override
                        public void buildVariantsConfigChanged() {
                            ResourceFolderManager.this.invalidate();
                        }
                    });
                }
            }
            if (!this.myGradleInitListenerAdded) {
                this.myGradleInitListenerAdded = true;
                this.myFacet.addListener(new GradleSyncListener.Adapter(){

                    @Override
                    public void syncSucceeded(Project project) {
                        ResourceFolderManager.this.invalidate();
                    }
                });
            }
            return resDirectories;
        }
        return new ArrayList<VirtualFile>(this.myFacet.getMainIdeaSourceProvider().getResDirectories());
    }

    private void notifyChanged(List<VirtualFile> before, List<VirtualFile> after) {
        ++this.myGeneration;
        HashSet added = new HashSet(after.size());
        added.addAll(after);
        added.removeAll(before);
        HashSet removed = new HashSet(before.size());
        removed.addAll(before);
        removed.removeAll(after);
        for (ResourceFolderListener listener : new ArrayList<ResourceFolderListener>(this.myListeners)) {
            listener.resourceFoldersChanged(this.myFacet, after, (Collection<VirtualFile>)added, (Collection<VirtualFile>)removed);
        }
    }

    public long getModificationCount() {
        return this.myGeneration;
    }

    public synchronized void addListener(ResourceFolderListener listener) {
        this.myListeners.add(listener);
    }

    public synchronized void removeListener(ResourceFolderListener listener) {
        this.myListeners.remove(listener);
    }

    public static void addAarsFromModuleLibraries(AndroidFacet facet, Set<File> dirs) {
        OrderEntry[] orderEntries;
        Module module = facet.getModule();
        for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrSdkOrderEntry) || !orderEntry.isValid() || !ResourceFolderManager.isAarDependency(facet, orderEntry)) continue;
            LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
            VirtualFile[] libClasses = entry.getRootFiles(OrderRootType.CLASSES);
            File res = null;
            for (VirtualFile root : libClasses) {
                if (!root.getName().equals("res")) continue;
                res = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                break;
            }
            if (res == null) {
                for (VirtualFile root : libClasses) {
                    File file = new File(VfsUtilCore.virtualToIoFile((VirtualFile)root).getParentFile(), "res");
                    if (!file.exists()) continue;
                    res = file;
                    break;
                }
            }
            if (res == null) continue;
            dirs.add(res);
        }
    }

    private static boolean isAarDependency(AndroidFacet facet, OrderEntry orderEntry) {
        if (facet.requiresAndroidModel() && orderEntry instanceof LibraryOrderEntry) {
            VirtualFile[] files = orderEntry.getFiles(OrderRootType.CLASSES);
            if (files.length >= 2) {
                for (VirtualFile file : files) {
                    if (!"res".equals(file.getName()) || !file.isDirectory()) continue;
                    return true;
                }
            }
            return false;
        }
        return AndroidMavenUtil.isMavenAarDependency(facet.getModule(), orderEntry);
    }

    public static boolean isLibraryResourceFile(VirtualFile file) {
        if (file != null) {
            return ResourceFolderManager.isLibraryResourceFolder(file.getParent());
        }
        return false;
    }

    public static boolean isLibraryResourceFolder(VirtualFile folder) {
        if (folder != null) {
            return ResourceFolderManager.isLibraryResourceRoot(folder.getParent());
        }
        return false;
    }

    public static boolean isLibraryResourceRoot(VirtualFile res) {
        String name;
        VirtualFile exploded;
        VirtualFile aar;
        return res != null && (aar = res.getParent()) != null && (exploded = aar.getParent()) != null && ((name = exploded.getName()).equals("exploded-bundles") || name.equals("exploded-aar"));
    }

    public static interface ResourceFolderListener {
        public void resourceFoldersChanged(AndroidFacet var1, List<VirtualFile> var2, Collection<VirtualFile> var3, Collection<VirtualFile> var4);
    }
}

