/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompiler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class AndroidRootUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.facet.AndroidRootUtil");
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "default.properties";

    private AndroidRootUtil() {
    }

    @Deprecated
    public static VirtualFile getManifestFile(AndroidFacet facet) {
        if (facet.requiresAndroidModel()) {
            return facet.getMainIdeaSourceProvider().getManifestFile();
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
    }

    public static VirtualFile getPrimaryManifestFile(AndroidFacet facet) {
        return facet.getMainIdeaSourceProvider().getManifestFile();
    }

    public static VirtualFile getCustomManifestFileForCompiler(AndroidFacet facet) {
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().CUSTOM_COMPILER_MANIFEST, false);
    }

    public static VirtualFile getManifestFileForCompiler(AndroidFacet facet) {
        return facet.getProperties().USE_CUSTOM_COMPILER_MANIFEST ? AndroidRootUtil.getCustomManifestFileForCompiler(facet) : AndroidRootUtil.getPrimaryManifestFile(facet);
    }

    @Deprecated
    public static VirtualFile getResourceDir(AndroidFacet facet) {
        return facet.getPrimaryResourceDir();
    }

    private static String suggestResourceDirPath(AndroidFacet facet) {
        Module module = facet.getModule();
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length == 0) {
            return null;
        }
        VirtualFile root = contentRoots[0];
        if (contentRoots.length > 1) {
            String moduleFileParentDirPath = FileUtil.toSystemIndependentName((String)new File(module.getModuleFilePath()).getParent());
            VirtualFile moduleFileParentDir = LocalFileSystem.getInstance().findFileByPath(moduleFileParentDirPath);
            if (moduleFileParentDir != null) {
                for (VirtualFile contentRoot : contentRoots) {
                    if (!Comparing.equal((Object)contentRoot, (Object)moduleFileParentDir)) continue;
                    root = contentRoot;
                }
            }
        }
        return root.getPath() + facet.getProperties().RES_FOLDER_RELATIVE_PATH;
    }

    public static String getResourceDirPath(AndroidFacet facet) {
        VirtualFile resourceDir = AndroidRootUtil.getResourceDir(facet);
        return resourceDir != null ? resourceDir.getPath() : AndroidRootUtil.suggestResourceDirPath(facet);
    }

    public static VirtualFile getFileByRelativeModulePath(Module module, String relativePath, boolean lookInContentRoot) {
        if (relativePath == null || relativePath.length() == 0) {
            return null;
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        String moduleDirPath = new File(module.getModuleFilePath()).getParent();
        if (moduleDirPath != null) {
            String absPath = FileUtil.toSystemIndependentName((String)(moduleDirPath + relativePath));
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(absPath);
            if (file != null) {
                return file;
            }
        }
        if (lookInContentRoot) {
            for (VirtualFile contentRoot : contentRoots) {
                String absPath = FileUtil.toSystemIndependentName((String)(contentRoot.getPath() + relativePath));
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(absPath);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    public static VirtualFile getAssetsDir(AndroidFacet facet) {
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().ASSETS_FOLDER_RELATIVE_PATH, false);
    }

    public static VirtualFile getLibsDir(AndroidFacet facet) {
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().LIBS_FOLDER_RELATIVE_PATH, false);
    }

    public static VirtualFile getAidlGenDir(AndroidFacet facet) {
        String genPath = AndroidRootUtil.getAidlGenSourceRootPath(facet);
        return genPath != null ? LocalFileSystem.getInstance().findFileByPath(genPath) : null;
    }

    public static VirtualFile getAaptGenDir(AndroidFacet facet) {
        String genPath = AndroidRootUtil.getAptGenSourceRootPath(facet);
        return genPath != null ? LocalFileSystem.getInstance().findFileByPath(genPath) : null;
    }

    public static VirtualFile getRenderscriptGenDir(AndroidFacet facet) {
        String path = AndroidRootUtil.getRenderscriptGenSourceRootPath(facet);
        return path != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    public static VirtualFile getBuildconfigGenDir(AndroidFacet facet) {
        String path = AndroidRootUtil.getBuildconfigGenSourceRootPath(facet);
        return path != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    public static VirtualFile getStandardGenDir(Module module) {
        return AndroidRootUtil.getFileByRelativeModulePath(module, "/gen", false);
    }

    private static void collectClassFilesAndJars(VirtualFile root, Set<VirtualFile> result, Set<VirtualFile> visited) {
        if (!visited.add(root)) {
            return;
        }
        for (VirtualFile child : root.getChildren()) {
            if (!child.exists()) continue;
            if (child.isDirectory()) {
                AndroidRootUtil.collectClassFilesAndJars(child, result, visited);
                continue;
            }
            if (!"jar".equals(child.getExtension()) && !"class".equals(child.getExtension())) continue;
            if (child.getFileSystem() instanceof JarFileSystem) {
                VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(child);
                if (localFile == null) continue;
                result.add(localFile);
                continue;
            }
            result.add(child);
        }
    }

    private static void fillExternalLibrariesAndModules(final Module module, final Set<VirtualFile> outputDirs, final Set<Module> visited, final Set<VirtualFile> libraries, final boolean exportedLibrariesOnly, final boolean recursive) {
        if (!visited.add(module)) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
                for (OrderEntry entry : manager.getOrderEntries()) {
                    Module depModule;
                    if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.COMPILE) continue;
                    if (libraries != null && entry instanceof LibraryOrderEntry) {
                        LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                        Library library = libraryOrderEntry.getLibrary();
                        if (library == null || exportedLibrariesOnly && !libraryOrderEntry.isExported()) continue;
                        for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                            if (!file.exists()) continue;
                            if (file.getFileType() instanceof ArchiveFileType) {
                                if (file.getFileSystem() instanceof JarFileSystem) {
                                    VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
                                    if (localFile == null) continue;
                                    libraries.add(localFile);
                                    continue;
                                }
                                libraries.add(file);
                                continue;
                            }
                            if (!file.isDirectory() || file.getFileSystem() instanceof JarFileSystem) continue;
                            AndroidRootUtil.collectClassFilesAndJars(file, libraries, new HashSet());
                        }
                        continue;
                    }
                    if (!(entry instanceof ModuleOrderEntry) || (depModule = ((ModuleOrderEntry)entry).getModule()) == null) continue;
                    AndroidFacet facet = AndroidFacet.getInstance(depModule);
                    boolean libraryProject = facet != null && facet.isLibraryProject();
                    CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)depModule);
                    if (extension != null) {
                        VirtualFile classDir = extension.getCompilerOutputPath();
                        if (libraryProject) {
                            VirtualFile packedClassesJar;
                            VirtualFile tmpArtifactsDir = AndroidDexCompiler.getOutputDirectoryForDex(depModule);
                            if (tmpArtifactsDir != null && (packedClassesJar = tmpArtifactsDir.findChild("classes.jar")) != null) {
                                outputDirs.add(packedClassesJar);
                            }
                        } else if (facet == null && !outputDirs.contains(classDir) && classDir != null && classDir.exists()) {
                            outputDirs.add(classDir);
                        }
                    }
                    if (!recursive) continue;
                    AndroidRootUtil.fillExternalLibrariesAndModules(depModule, outputDirs, visited, libraries, !libraryProject || exportedLibrariesOnly, true);
                }
            }
        });
    }

    public static List<VirtualFile> getExternalLibraries(Module module) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        OrderedSet libs = new OrderedSet();
        boolean recursive = !AndroidMavenUtil.isMavenizedModule(module);
        AndroidRootUtil.fillExternalLibrariesAndModules(module, files, new HashSet<Module>(), (Set<VirtualFile>)libs, false, recursive);
        AndroidRootUtil.addAnnotationsJar(module, (OrderedSet<VirtualFile>)libs);
        return libs;
    }

    private static void addAnnotationsJar(Module module, OrderedSet<VirtualFile> libs) {
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null || !AndroidSdkUtils.isAndroidSdk(sdk)) {
            return;
        }
        String sdkHomePath = sdk.getHomePath();
        if (sdkHomePath == null) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null && platform.needToAddAnnotationsJarToClasspath()) {
            String annotationsJarPath = FileUtil.toSystemIndependentName((String)sdkHomePath) + "/tools/support/annotations.jar";
            VirtualFile annotationsJar = LocalFileSystem.getInstance().findFileByPath(annotationsJarPath);
            if (annotationsJar != null) {
                libs.add((Object)annotationsJar);
            }
        }
    }

    public static List<VirtualFile> getExternalAssetsDirs(Module module) {
        AndroidGradleModel androidGradleModel = AndroidGradleModel.get(module);
        if (androidGradleModel != null) {
            LinkedHashSet assetsDirs = Sets.newLinkedHashSet();
            Collection libraries = androidGradleModel.getSelectedVariant().getMainArtifact().getDependencies().getLibraries();
            for (AndroidLibrary library : libraries) {
                AndroidRootUtil.fillAssetsDirs(library, assetsDirs);
            }
            return ImmutableList.copyOf((Collection)assetsDirs);
        }
        return ImmutableList.of();
    }

    private static void fillAssetsDirs(AndroidLibrary library, LinkedHashSet<VirtualFile> assetsDirs) {
        File assetsFolder = library.getAssetsFolder();
        VirtualFile virtualAssetsFolder = VfsUtil.findFileByIoFile((File)assetsFolder, (boolean)true);
        if (virtualAssetsFolder != null) {
            assetsDirs.add(virtualAssetsFolder);
        }
        List libraryDependencies = library.getLibraryDependencies();
        for (AndroidLibrary depLibrary : libraryDependencies) {
            AndroidRootUtil.fillAssetsDirs(depLibrary, assetsDirs);
        }
    }

    public static Set<VirtualFile> getDependentModules(Module module, VirtualFile moduleOutputDir) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        AndroidRootUtil.fillExternalLibrariesAndModules(module, files, new HashSet<Module>(), null, false, true);
        files.remove(moduleOutputDir);
        return files;
    }

    public static VirtualFile[] getResourceOverlayDirs(AndroidFacet facet) {
        List overlayFolders = facet.getProperties().RES_OVERLAY_FOLDERS;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String overlayFolder : overlayFolders) {
            VirtualFile overlayDir = AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), overlayFolder, true);
            if (overlayDir == null) continue;
            result.add(overlayDir);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    public static String getModuleDirPath(Module module) {
        String moduleFilePath = module.getModuleFilePath();
        String moduleDirPath = new File(moduleFilePath).getParent();
        if (moduleDirPath != null) {
            moduleDirPath = FileUtil.toSystemIndependentName((String)moduleDirPath);
        }
        return moduleDirPath;
    }

    public static String getRenderscriptGenSourceRootPath(AndroidFacet facet) {
        return AndroidRootUtil.getAidlGenSourceRootPath(facet);
    }

    public static String getBuildconfigGenSourceRootPath(AndroidFacet facet) {
        return AndroidRootUtil.getAptGenSourceRootPath(facet);
    }

    public static VirtualFile getMainContentRoot(AndroidFacet facet) {
        Module module = facet.getModule();
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length == 0) {
            return null;
        }
        if (contentRoots.length == 1) {
            return contentRoots[0];
        }
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet);
        if (manifestFile != null) {
            for (VirtualFile root : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)manifestFile, (boolean)true)) continue;
                return root;
            }
        }
        return contentRoots[0];
    }

    public static Pair<PropertiesFile, VirtualFile> findPropertyFile(Module module, String propertyFileName) {
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            PsiFile psiFile;
            VirtualFile vFile = contentRoot.findChild(propertyFileName);
            if (vFile == null || !((psiFile = AndroidPsiUtils.getPsiFileSafely(module.getProject(), vFile)) instanceof PropertiesFile)) continue;
            return Pair.create((Object)((PropertiesFile)psiFile), (Object)vFile);
        }
        return null;
    }

    public static Pair<Properties, VirtualFile> readPropertyFile(Module module, String propertyFileName) {
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            Pair<Properties, VirtualFile> result = AndroidRootUtil.readPropertyFile(contentRoot, propertyFileName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Pair<Properties, VirtualFile> readProjectPropertyFile(Module module) {
        Pair<Properties, VirtualFile> pair = AndroidRootUtil.readPropertyFile(module, "project.properties");
        return pair != null ? pair : AndroidRootUtil.readPropertyFile(module, DEFAULT_PROPERTIES_FILE_NAME);
    }

    private static Pair<Properties, VirtualFile> readPropertyFile(VirtualFile contentRoot, String propertyFileName) {
        VirtualFile vFile = contentRoot.findChild(propertyFileName);
        if (vFile != null) {
            try {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)vFile);
                Properties properties = PropertiesUtil.getProperties(file);
                return Pair.create((Object)properties, (Object)vFile);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    public static Pair<Properties, VirtualFile> readProjectPropertyFile(VirtualFile contentRoot) {
        Pair<Properties, VirtualFile> pair = AndroidRootUtil.readPropertyFile(contentRoot, "project.properties");
        return pair != null ? pair : AndroidRootUtil.readPropertyFile(contentRoot, DEFAULT_PROPERTIES_FILE_NAME);
    }

    public static Pair<String, VirtualFile> getPropertyValue(Module module, String propertyFileName, String propertyKey) {
        String value;
        Pair<Properties, VirtualFile> pair = AndroidRootUtil.readPropertyFile(module, propertyFileName);
        if (pair != null && (value = ((Properties)pair.first).getProperty(propertyKey)) != null) {
            return Pair.create((Object)value, (Object)pair.second);
        }
        return null;
    }

    public static Pair<String, VirtualFile> getProjectPropertyValue(Module module, String propertyName) {
        Pair<String, VirtualFile> result = AndroidRootUtil.getPropertyValue(module, "project.properties", propertyName);
        return result != null ? result : AndroidRootUtil.getPropertyValue(module, DEFAULT_PROPERTIES_FILE_NAME, propertyName);
    }

    public static String getAptGenSourceRootPath(AndroidFacet facet) {
        String path = facet.getProperties().GEN_FOLDER_RELATIVE_PATH_APT;
        if (path.length() == 0) {
            return null;
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(facet.getModule());
        return moduleDirPath != null ? moduleDirPath + path : null;
    }

    public static String getAidlGenSourceRootPath(AndroidFacet facet) {
        String path = facet.getProperties().GEN_FOLDER_RELATIVE_PATH_AIDL;
        if (path.length() == 0) {
            return null;
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(facet.getModule());
        return moduleDirPath != null ? moduleDirPath + path : null;
    }

    public static String getApkPath(AndroidFacet facet) {
        if (facet.requiresAndroidModel()) {
            AndroidGradleModel androidGradleModel = AndroidGradleModel.get(facet);
            if (androidGradleModel != null) {
                AndroidArtifact mainArtifact = androidGradleModel.getMainArtifact();
                AndroidArtifactOutput output = GradleUtil.getOutput(mainArtifact);
                File outputFile = output.getMainOutputFile().getOutputFile();
                return outputFile.getAbsolutePath();
            }
            return null;
        }
        String path = facet.getProperties().APK_PATH;
        if (path.length() == 0) {
            return AndroidCompileUtil.getOutputPackage(facet.getModule());
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(facet.getModule());
        return moduleDirPath != null ? FileUtil.toSystemDependentName((String)(moduleDirPath + path)) : null;
    }

    public static String getPathRelativeToModuleDir(Module module, String path) {
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(module);
        if (moduleDirPath == null) {
            return null;
        }
        if (moduleDirPath.equals(path)) {
            return "";
        }
        return FileUtil.getRelativePath((String)moduleDirPath, (String)path, (char)'/');
    }
}

