/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.SourceProvider;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.FileResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ModuleResourceRepository;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.ResourceFolderRegistry;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.templates.TemplateManager;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.android.facet.AndroidResourceFilesListener;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.AvdsNotSupportedException;
import org.jetbrains.android.facet.ClassMapConstructor;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.AvdManagerLog;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidFacet
extends Facet<AndroidFacetConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.facet.AndroidFacet");
    public static final FacetTypeId<AndroidFacet> ID = new FacetTypeId("android");
    public static final String NAME = "Android";
    private static final Object APP_RESOURCES_LOCK = new Object();
    private static final Object PROJECT_RESOURCES_LOCK = new Object();
    private static final Object MODULE_RESOURCES_LOCK = new Object();
    private static boolean ourDynamicTemplateMenuCreated;
    private AvdManager myAvdManager = null;
    private AndroidSdkData mySdkData;
    private boolean myDataBindingEnabled = false;
    private SystemResourceManager myPublicSystemResourceManager;
    private SystemResourceManager myFullSystemResourceManager;
    private LocalResourceManager myLocalResourceManager;
    private final Map<String, Map<String, SmartPsiElementPointer<PsiClass>>> myInitialClassMaps = Maps.newHashMap();
    private Map<String, CachedValue<Map<String, PsiClass>>> myClassMaps = Maps.newHashMap();
    private final Object myClassMapLock = new Object();
    private final Set<AndroidAutogeneratorMode> myDirtyModes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
    private final Map<AndroidAutogeneratorMode, Set<String>> myAutogeneratedFiles = Maps.newHashMap();
    private volatile boolean myAutogenerationEnabled = false;
    private ConfigurationManager myConfigurationManager;
    private LocalResourceRepository myModuleResources;
    private AppResourceRepository myAppResources;
    private ProjectResourceRepository myProjectResources;
    private AndroidModel myAndroidModel;
    private final ResourceFolderManager myFolderManager = new ResourceFolderManager(this);
    private SourceProvider myMainSourceSet;
    private IdeaSourceProvider myMainIdeaSourceSet;
    private final AndroidModuleInfo myAndroidModuleInfo = AndroidModuleInfo.create(this);
    private RenderService myRenderService;
    private DataBindingUtil.LightBrClass myLightBrClass;

    public AndroidFacet(Module module, String name, AndroidFacetConfiguration configuration) {
        super((FacetType)AndroidFacet.getFacetType(), module, name, (FacetConfiguration)configuration, null);
        configuration.setFacet(this);
    }

    public boolean isAutogenerationEnabled() {
        return this.myAutogenerationEnabled;
    }

    public boolean requiresAndroidModel() {
        return !this.getProperties().ALLOW_USER_CONFIGURATION;
    }

    public AndroidModel getAndroidModel() {
        return this.myAndroidModel;
    }

    public void setAndroidModel(AndroidModel androidModel) {
        this.myAndroidModel = androidModel;
        DataBindingUtil.onIdeaProjectSet(this);
    }

    public boolean isLibraryProject() {
        return this.getProperties().LIBRARY_PROJECT;
    }

    public void setLibraryProject(boolean library) {
        this.getProperties().LIBRARY_PROJECT = library;
    }

    public SourceProvider getMainSourceProvider() {
        if (this.myAndroidModel != null) {
            return this.myAndroidModel.getDefaultSourceProvider();
        }
        if (this.myMainSourceSet == null) {
            this.myMainSourceSet = new LegacySourceProvider();
        }
        return this.myMainSourceSet;
    }

    public IdeaSourceProvider getMainIdeaSourceProvider() {
        if (!this.requiresAndroidModel()) {
            if (this.myMainIdeaSourceSet == null) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.create(this);
            }
        } else {
            SourceProvider mainSourceSet = this.getMainSourceProvider();
            if (this.myMainIdeaSourceSet == null || mainSourceSet != this.myMainSourceSet) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.create(mainSourceSet);
            }
        }
        return this.myMainIdeaSourceSet;
    }

    public ResourceFolderManager getResourceFolderManager() {
        return this.myFolderManager;
    }

    public List<VirtualFile> getAllResourceDirectories() {
        return this.myFolderManager.getFolders();
    }

    @Deprecated
    public VirtualFile getPrimaryResourceDir() {
        List<VirtualFile> dirs = this.getAllResourceDirectories();
        if (!dirs.isEmpty()) {
            return dirs.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGeneratedFileRemoved(AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> filePaths = this.myAutogeneratedFiles.get((Object)mode);
            if (filePaths != null) {
                for (String path : filePaths) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                    if (file != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAutogeneratedFiles(AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set != null) {
                set.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileAutogenerated(AndroidAutogeneratorMode mode, VirtualFile file) {
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            HashSet set = this.myAutogeneratedFiles.get((Object)mode);
            if (set == null) {
                set = Sets.newHashSet();
                this.myAutogeneratedFiles.put(mode, set);
            }
            set.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAutogeneratedFiles(AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            return set != null ? Sets.newHashSet(set) : Collections.emptySet();
        }
    }

    private void activateSourceAutogenerating() {
        this.myAutogenerationEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearClassMaps() {
        Object object = this.myClassMapLock;
        synchronized (object) {
            this.myInitialClassMaps.clear();
        }
    }

    public void androidPlatformChanged() {
        this.myAvdManager = null;
        this.myLocalResourceManager = null;
        this.myPublicSystemResourceManager = null;
        this.clearClassMaps();
    }

    public AvdInfo[] getAllAvds() {
        AvdManager manager = this.getAvdManagerSilently();
        if (manager != null && this.reloadAvds(manager)) {
            return manager.getAllAvds();
        }
        return new AvdInfo[0];
    }

    private boolean reloadAvds(AvdManager manager) {
        try {
            MessageBuildingSdkLog log = new MessageBuildingSdkLog();
            manager.reloadAvds((ILogger)log);
            if (!log.getErrorMessage().isEmpty()) {
                String message = AndroidBundle.message("cant.load.avds.error.prefix", new Object[0]) + ' ' + log.getErrorMessage();
                Messages.showErrorDialog((Project)this.getModule().getProject(), (String)message, (String)CommonBundle.getErrorTitle());
            }
            return true;
        }
        catch (AndroidLocation.AndroidLocationException e) {
            Messages.showErrorDialog((Project)this.getModule().getProject(), (String)AndroidBundle.message("cant.load.avds.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return false;
        }
    }

    public AvdInfo[] getValidCompatibleAvds() {
        AvdManager manager = this.getAvdManagerSilently();
        ArrayList result = Lists.newArrayList();
        if (manager != null && this.reloadAvds(manager)) {
            this.addCompatibleAvds(result, manager.getValidAvds());
        }
        return result.toArray(new AvdInfo[result.size()]);
    }

    private AvdInfo[] addCompatibleAvds(List<AvdInfo> to, AvdInfo[] from) {
        AndroidVersion minSdk = AndroidModuleInfo.get(this).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            LOG.error("Android Platform not set for module: " + this.getModule().getName());
            return new AvdInfo[0];
        }
        for (AvdInfo avd : from) {
            IAndroidTarget avdTarget = avd.getTarget();
            if (avdTarget != null && LaunchCompatibility.canRunOnAvd(minSdk, platform.getTarget(), avdTarget).isCompatible() == ThreeState.NO) continue;
            to.add(avd);
        }
        return to.toArray(new AvdInfo[to.size()]);
    }

    public AvdManager getAvdManagerSilently() {
        try {
            return this.getAvdManager(new AvdManagerLog());
        }
        catch (AvdsNotSupportedException ignored) {
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            // empty catch block
        }
        return null;
    }

    public AvdManager getAvdManager(ILogger log) throws AvdsNotSupportedException, AndroidLocation.AndroidLocationException {
        if (this.myAvdManager == null) {
            AndroidSdkData sdkData = this.getSdkData();
            if (sdkData != null) {
                this.myAvdManager = AvdManager.getInstance((LocalSdk)sdkData.getLocalSdk(), (ILogger)log);
            } else {
                throw new AvdsNotSupportedException();
            }
        }
        return this.myAvdManager;
    }

    public AndroidSdkData getSdkData() {
        if (this.mySdkData == null) {
            AndroidPlatform platform = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform();
            this.mySdkData = platform != null ? platform.getSdkData() : null;
        }
        return this.mySdkData;
    }

    public IAndroidTarget getTargetFromHashString(String hash) {
        AndroidSdkData sdkData = this.getSdkData();
        return sdkData != null ? sdkData.getLocalSdk().getTargetFromHashString(hash) : null;
    }

    public void launchEmulator(String avdName) {
        AvdManager manager = this.getAvdManagerSilently();
        if (manager == null) {
            LOG.warn("Could not obtain AVD Manager.");
            return;
        }
        AvdInfo avdInfo = manager.getAvd(avdName, true);
        if (avdInfo == null) {
            LOG.warn("Unable to obtain info for AVD: " + avdName);
            return;
        }
        AvdManagerConnection.getDefaultAvdManagerConnection().startAvd(this.getModule().getProject(), avdInfo);
    }

    public static void createDynamicTemplateMenu() {
        if (ourDynamicTemplateMenuCreated) {
            return;
        }
        ourDynamicTemplateMenuCreated = true;
        DefaultActionGroup newGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("NewGroup");
        newGroup.addSeparator();
        ActionGroup menu = TemplateManager.getInstance().getTemplateCreationMenu(null);
        if (menu != null) {
            newGroup.add((AnAction)menu, new Constraints(Anchor.AFTER, "NewFromTemplate"));
        }
    }

    public void initFacet() {
        StartupManager.getInstance((Project)this.getModule().getProject()).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                AndroidResourceFilesListener.notifyFacetInitialized(AndroidFacet.this);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                AndroidFacet.this.addResourceFolderToSdkRootsIfNecessary();
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        Module module = AndroidFacet.this.getModule();
                        Project project = module.getProject();
                        if (project.isDisposed()) {
                            return;
                        }
                        AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AAPT);
                        AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AIDL);
                        AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.RENDERSCRIPT);
                        AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.BUILDCONFIG);
                        AndroidFacet.this.activateSourceAutogenerating();
                    }
                });
            }
        });
        this.getModule().getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){
            private Sdk myPrevSdk;

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (AndroidFacet.this.isDisposed()) {
                            return;
                        }
                        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)AndroidFacet.this.getModule());
                        Sdk newSdk = rootManager.getSdk();
                        if (newSdk != null && newSdk.getSdkType() instanceof AndroidSdkType && !newSdk.equals(myPrevSdk)) {
                            AndroidFacet.this.androidPlatformChanged();
                            Set set = AndroidFacet.this.myDirtyModes;
                            synchronized (set) {
                                AndroidFacet.this.myDirtyModes.addAll(Arrays.asList(AndroidAutogeneratorMode.values()));
                            }
                        } else {
                            AndroidFacet.this.clearClassMaps();
                        }
                        myPrevSdk = newSdk;
                    }
                });
            }
        });
        AndroidFacet.createDynamicTemplateMenu();
    }

    private void addResourceFolderToSdkRootsIfNecessary() {
        Sdk sdk = ModuleRootManager.getInstance((Module)this.getModule()).getSdk();
        if (sdk == null || !AndroidSdkUtils.isAndroidSdk(sdk)) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
        if (platform == null) {
            return;
        }
        String resFolderPath = platform.getTarget().getPath(11);
        if (resFolderPath == null) {
            return;
        }
        ArrayList filesToAdd = Lists.newArrayList();
        VirtualFile resFolder = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)resFolderPath));
        if (resFolder != null) {
            filesToAdd.add(resFolder);
        }
        if (platform.needToAddAnnotationsJarToClasspath()) {
            String sdkHomePath = FileUtil.toSystemIndependentName((String)platform.getSdkData().getLocation().getPath());
            VirtualFile annotationsJar = JarFileSystem.getInstance().findFileByPath(sdkHomePath + "/tools/support/annotations.jar" + "!/");
            if (annotationsJar != null) {
                filesToAdd.add(annotationsJar);
            }
        }
        AndroidFacet.addFilesToSdkIfNecessary(sdk, filesToAdd);
    }

    private static void addFilesToSdkIfNecessary(Sdk sdk, Collection<VirtualFile> files) {
        ArrayList newFiles = Lists.newArrayList(files);
        newFiles.removeAll(Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)));
        if (newFiles.size() > 0) {
            SdkModificator modificator = sdk.getSdkModificator();
            for (VirtualFile file : newFiles) {
                modificator.addRoot(file, OrderRootType.CLASSES);
            }
            modificator.commitChanges();
        }
    }

    public void disposeFacet() {
        if (this.myConfigurationManager != null) {
            Disposer.dispose((Disposable)this.myConfigurationManager);
        }
    }

    public static AndroidFacet getInstance(Module module) {
        return (AndroidFacet)FacetManager.getInstance((Module)module).getFacetByType(ID);
    }

    public static AndroidFacet getInstance(ConvertContext context) {
        Module module = context.getModule();
        return module != null ? AndroidFacet.getInstance(module) : null;
    }

    public static AndroidFacet getInstance(PsiElement element) {
        Module module = AndroidPsiUtils.getModuleSafely(element);
        return module != null ? AndroidFacet.getInstance(module) : null;
    }

    public static AndroidFacet getInstance(DomElement element) {
        Module module = element.getModule();
        return module != null ? AndroidFacet.getInstance(module) : null;
    }

    public ResourceManager getResourceManager(String resourcePackage) {
        return this.getResourceManager(resourcePackage, null);
    }

    public ResourceManager getResourceManager(String resourcePackage, PsiElement contextElement) {
        if ("android".equals(resourcePackage)) {
            return this.getSystemResourceManager();
        }
        if (contextElement != null && AndroidFacet.isInAndroidSdk(contextElement)) {
            return this.getSystemResourceManager();
        }
        return this.getLocalResourceManager();
    }

    private static boolean isInAndroidSdk(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        List entries = projectFileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry entry : entries) {
            Sdk sdk;
            if (!(entry instanceof JdkOrderEntry) || (sdk = ((JdkOrderEntry)entry).getJdk()) == null || !(sdk.getSdkType() instanceof AndroidSdkType)) continue;
            return true;
        }
        return false;
    }

    public LocalResourceManager getLocalResourceManager() {
        if (this.myLocalResourceManager == null) {
            this.myLocalResourceManager = new LocalResourceManager(this);
        }
        return this.myLocalResourceManager;
    }

    public SystemResourceManager getSystemResourceManager() {
        return this.getSystemResourceManager(true);
    }

    public SystemResourceManager getSystemResourceManager(boolean publicOnly) {
        AndroidPlatform platform;
        if (publicOnly) {
            AndroidPlatform platform2;
            if (this.myPublicSystemResourceManager == null && (platform2 = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform()) != null) {
                this.myPublicSystemResourceManager = new SystemResourceManager(this.getModule().getProject(), platform2, true);
            }
            return this.myPublicSystemResourceManager;
        }
        if (this.myFullSystemResourceManager == null && (platform = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform()) != null) {
            this.myFullSystemResourceManager = new SystemResourceManager(this.getModule().getProject(), platform, false);
        }
        return this.myFullSystemResourceManager;
    }

    public Manifest getManifest() {
        VirtualFile manifestFile = this.getMainIdeaSourceProvider().getManifestFile();
        return manifestFile != null ? AndroidUtils.loadDomElement(this.getModule(), manifestFile, Manifest.class) : null;
    }

    public static AndroidFacetType getFacetType() {
        return (AndroidFacetType)FacetTypeRegistry.getInstance().findFacetType(ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PsiClass> getClassMap(final String className, final ClassMapConstructor constructor) {
        Object object = this.myClassMapLock;
        synchronized (object) {
            CachedValue value = this.myClassMaps.get(className);
            if (value == null) {
                value = CachedValuesManager.getManager((Project)this.getModule().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, PsiClass>>(){

                    public CachedValueProvider.Result<Map<String, PsiClass>> compute() {
                        Map map = AndroidFacet.this.computeClassMap(className, constructor);
                        return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                    }
                }, false);
                this.myClassMaps.put(className, (CachedValue<Map<String, PsiClass>>)value);
            }
            return (Map)value.getValue();
        }
    }

    private Map<String, PsiClass> computeClassMap(String className, ClassMapConstructor constructor) {
        PsiClass aClass;
        SmartPsiElementPointer<PsiClass> pointer;
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.getInitialClassMap(className, constructor, false);
        HashMap result = Maps.newHashMap();
        boolean shouldRebuildInitialMap = false;
        for (String key : classMap.keySet()) {
            pointer = classMap.get(key);
            if (!AndroidFacet.isUpToDate(pointer, key, constructor)) {
                shouldRebuildInitialMap = true;
                break;
            }
            aClass = (PsiClass)pointer.getElement();
            if (aClass == null) continue;
            result.put(key, aClass);
        }
        if (shouldRebuildInitialMap) {
            result.clear();
            classMap = this.getInitialClassMap(className, constructor, true);
            for (String key : classMap.keySet()) {
                pointer = classMap.get(key);
                aClass = (PsiClass)pointer.getElement();
                if (aClass == null) continue;
                result.put(key, aClass);
            }
        }
        Project project = this.getModule().getProject();
        this.fillMap(className, constructor, ProjectScope.getProjectScope((Project)project), result, false);
        return result;
    }

    private static boolean isUpToDate(SmartPsiElementPointer<PsiClass> pointer, String tagName, ClassMapConstructor constructor) {
        PsiClass aClass = (PsiClass)pointer.getElement();
        if (aClass == null) {
            return false;
        }
        Object[] tagNames = constructor.getTagNamesByClass(aClass, -1);
        return ArrayUtilRt.find((Object[])tagNames, (Object)tagName) >= 0;
    }

    private Map<String, SmartPsiElementPointer<PsiClass>> getInitialClassMap(String className, ClassMapConstructor constructor, boolean forceRebuild) {
        HashMap viewClassMap = this.myInitialClassMaps.get(className);
        if (viewClassMap != null && !forceRebuild) {
            return viewClassMap;
        }
        HashMap map = Maps.newHashMap();
        if (this.fillMap(className, constructor, this.getModule().getModuleWithDependenciesAndLibrariesScope(true), map, true)) {
            viewClassMap = Maps.newHashMapWithExpectedSize((int)map.size());
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.getModule().getProject());
            for (Map.Entry entry : map.entrySet()) {
                viewClassMap.put(entry.getKey(), manager.createSmartPsiElementPointer((PsiElement)entry.getValue()));
            }
            this.myInitialClassMaps.put(className, viewClassMap);
        }
        return viewClassMap != null ? viewClassMap : Collections.emptyMap();
    }

    private boolean fillMap(final String className, final ClassMapConstructor constructor, GlobalSearchScope scope, final Map<String, PsiClass> map, final boolean libClassesOnly) {
        final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getModule().getProject());
        PsiClass baseClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                PsiClass aClass;
                try {
                    aClass = facade.findClass(className, AndroidFacet.this.getModule().getModuleWithDependenciesAndLibrariesScope(true));
                }
                catch (IndexNotReadyException e) {
                    aClass = null;
                }
                return aClass;
            }
        });
        if (baseClass != null) {
            String[] baseClassTagNames;
            for (String tagName : baseClassTagNames = constructor.getTagNamesByClass(baseClass, this.getModuleMinApi())) {
                map.put(tagName, baseClass);
            }
            try {
                ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true).forEach((Processor)new Processor<PsiClass>(){

                    public boolean process(PsiClass c) {
                        String[] tagNames;
                        if (libClassesOnly && c.getManager().isInProject((PsiElement)c)) {
                            return true;
                        }
                        for (String tagName : tagNames = constructor.getTagNamesByClass(c, AndroidFacet.this.getModuleMinApi())) {
                            map.put(tagName, c);
                        }
                        return true;
                    }
                });
            }
            catch (IndexNotReadyException e) {
                LOG.info((Throwable)e);
                return false;
            }
        }
        return map.size() > 0;
    }

    public int getModuleMinApi() {
        return this.getAndroidModuleInfo().getMinSdkVersion().getApiLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSourceRegenerating(AndroidAutogeneratorMode mode) {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            this.myDirtyModes.add(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanRegeneratingState(AndroidAutogeneratorMode mode) {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            return this.myDirtyModes.remove((Object)mode);
        }
    }

    public ConfigurationManager getConfigurationManager() {
        return this.getConfigurationManager(true);
    }

    public ConfigurationManager getConfigurationManager(boolean createIfNecessary) {
        if (this.myConfigurationManager == null && createIfNecessary) {
            this.myConfigurationManager = ConfigurationManager.create(this.getModule());
            Disposer.register((Disposable)this, (Disposable)this.myConfigurationManager);
        }
        return this.myConfigurationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppResourceRepository getAppResources(boolean createIfNecessary) {
        Object object = APP_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myAppResources == null && createIfNecessary) {
                this.myAppResources = AppResourceRepository.create(this);
            }
            return this.myAppResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectResourceRepository getProjectResources(boolean createIfNecessary) {
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources == null && createIfNecessary) {
                this.myProjectResources = ProjectResourceRepository.create(this);
            }
            return this.myProjectResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalResourceRepository getModuleResources(boolean createIfNecessary) {
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myModuleResources == null && createIfNecessary) {
                this.myModuleResources = ModuleResourceRepository.create(this);
            }
            return this.myModuleResources;
        }
    }

    public void refreshResources() {
        this.myModuleResources = null;
        this.myProjectResources = null;
        this.myAppResources = null;
        this.myConfigurationManager.getResolverCache().reset();
        ResourceFolderRegistry.reset();
        FileResourceRepository.reset();
    }

    public JpsAndroidModuleProperties getProperties() {
        JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)this.getConfiguration()).getState();
        assert (state != null);
        return state;
    }

    public boolean isDataBindingEnabled() {
        return this.myDataBindingEnabled;
    }

    public void setDataBindingEnabled(boolean dataBindingEnabled) {
        this.myDataBindingEnabled = dataBindingEnabled;
    }

    public void addListener(GradleSyncListener listener) {
        Module module = this.getModule();
        GradleSyncState.subscribe(module.getProject(), listener, (Disposable)module);
    }

    public AndroidModuleInfo getAndroidModuleInfo() {
        return this.myAndroidModuleInfo;
    }

    public RenderService getRenderService() {
        if (this.myRenderService == null) {
            this.myRenderService = new RenderService(this);
        }
        return this.myRenderService;
    }

    public void setLightBrClass(DataBindingUtil.LightBrClass lightBrClass) {
        this.myLightBrClass = lightBrClass;
    }

    public DataBindingUtil.LightBrClass getLightBrClass() {
        return this.myLightBrClass;
    }

    private class LegacySourceProvider
    implements SourceProvider {
        private LegacySourceProvider() {
        }

        public String getName() {
            return "main";
        }

        public File getManifestFile() {
            Module module = AndroidFacet.this.getModule();
            VirtualFile manifestFile = AndroidRootUtil.getFileByRelativeModulePath(module, AndroidFacet.this.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
            if (manifestFile == null) {
                VirtualFile root;
                VirtualFile virtualFile = root = !AndroidFacet.this.requiresAndroidModel() ? AndroidRootUtil.getMainContentRoot(AndroidFacet.this) : null;
                if (root != null) {
                    return new File(VfsUtilCore.virtualToIoFile((VirtualFile)root), "AndroidManifest.xml");
                }
                return new File("AndroidManifest.xml");
            }
            return VfsUtilCore.virtualToIoFile((VirtualFile)manifestFile);
        }

        public Set<File> getJavaDirectories() {
            HashSet dirs = Sets.newHashSet();
            Module module = AndroidFacet.this.getModule();
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (contentRoots.length != 0) {
                for (VirtualFile root : contentRoots) {
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
            }
            return dirs;
        }

        public Set<File> getResourcesDirectories() {
            return Collections.emptySet();
        }

        public Set<File> getAidlDirectories() {
            VirtualFile dir = AndroidRootUtil.getAidlGenDir(AndroidFacet.this);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Set<File> getRenderscriptDirectories() {
            VirtualFile dir = AndroidRootUtil.getRenderscriptGenDir(AndroidFacet.this);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Set<File> getResDirectories() {
            String resRelPath = AndroidFacet.this.getProperties().RES_FOLDER_RELATIVE_PATH;
            VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(AndroidFacet.this.getModule(), resRelPath, true);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Set<File> getAssetsDirectories() {
            VirtualFile dir = AndroidRootUtil.getAssetsDir(AndroidFacet.this);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Collection<File> getJniLibsDirectories() {
            return Collections.emptyList();
        }

        public Collection<File> getCDirectories() {
            return Collections.emptyList();
        }

        public Collection<File> getCppDirectories() {
            return Collections.emptyList();
        }
    }
}

