/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.util.AndroidBundle;

public class GradleSignStep
extends ExportSignedPackageWizardStep {
    private static final String PROPERTY_APK_PATH = "ExportApk.ApkPath";
    private static final String PROPERTY_BUILD_TYPE = "ExportApk.BuildType";
    private static final String PROPERTY_FLAVORS = "ExportApk.Flavors";
    private JPanel myContentPanel;
    private TextFieldWithBrowseButton myApkPathField;
    private JComboBox myBuildTypeCombo;
    private JBList myFlavorsList;
    private final ExportSignedPackageWizard myWizard;
    private final DefaultListModel myFlavorsListModel;
    private final DefaultComboBoxModel myBuildTypeComboModel;
    private AndroidGradleModel myAndroidModel;

    public GradleSignStep(ExportSignedPackageWizard exportSignedPackageWizard) {
        this.$$$setupUI$$$();
        this.myFlavorsListModel = new DefaultListModel();
        this.myBuildTypeComboModel = new DefaultComboBoxModel();
        this.myWizard = exportSignedPackageWizard;
        this.myFlavorsList.setModel((ListModel)this.myFlavorsListModel);
        this.myFlavorsList.setEmptyText(AndroidBundle.message("android.apk.sign.gradle.no.flavors", new Object[0]));
        new ListSpeedSearch((JList)this.myFlavorsList);
        this.myBuildTypeCombo.setModel(this.myBuildTypeComboModel);
    }

    public void _init() {
        ArrayList productFlavors;
        this.myAndroidModel = AndroidGradleModel.get(this.myWizard.getFacet());
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myWizard.getProject());
        String lastSelectedBuildType = properties.getValue(PROPERTY_BUILD_TYPE);
        this.myBuildTypeComboModel.removeAllElements();
        Set<String> buildTypes = this.myAndroidModel == null ? Collections.emptySet() : this.myAndroidModel.getBuildTypes();
        for (String buildType : buildTypes) {
            this.myBuildTypeComboModel.addElement(buildType);
            if ((lastSelectedBuildType != null || !buildType.equals("release")) && !buildType.equals(lastSelectedBuildType)) continue;
            this.myBuildTypeComboModel.setSelectedItem(buildType);
        }
        this.myFlavorsListModel.clear();
        if (this.myAndroidModel == null || this.myAndroidModel.getProductFlavors().isEmpty()) {
            productFlavors = Collections.emptyList();
        } else {
            HashSet mergedFlavors = Sets.newHashSet();
            for (Variant v : this.myAndroidModel.getAndroidProject().getVariants()) {
                mergedFlavors.add(ExportSignedPackageWizard.getMergedFlavorName(v));
            }
            productFlavors = Lists.newArrayList((Iterable)mergedFlavors);
            Collections.sort(productFlavors);
        }
        TIntArrayList lastSelectedIndices = new TIntArrayList(productFlavors.size());
        Object[] flavors = properties.getValues(PROPERTY_FLAVORS);
        HashSet lastSelectedFlavors = flavors == null ? Collections.emptySet() : Sets.newHashSet((Object[])flavors);
        for (int i = 0; i < productFlavors.size(); ++i) {
            String flavor = (String)productFlavors.get(i);
            this.myFlavorsListModel.addElement(flavor);
            if (!lastSelectedFlavors.contains(flavor)) continue;
            lastSelectedIndices.add(i);
        }
        this.myFlavorsList.setSelectedIndices(lastSelectedIndices.toNativeArray());
        String lastApkFolderPath = properties.getValue(PROPERTY_APK_PATH);
        File lastApkFolder = lastApkFolderPath != null ? new File(lastApkFolderPath) : (this.myAndroidModel == null ? VfsUtilCore.virtualToIoFile((VirtualFile)this.myWizard.getProject().getBaseDir()) : this.myAndroidModel.getRootDirPath());
        this.myApkPathField.setText(lastApkFolder.getAbsolutePath());
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myApkPathField.addBrowseFolderListener("Select APK Destination Folder", null, this.myWizard.getProject(), descriptor);
    }

    @Override
    public String getHelpId() {
        return null;
    }

    @Override
    protected void commitForNext() throws CommitStepException {
        if (this.myAndroidModel == null) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.no.model", new Object[0]));
        }
        String apkFolder = this.myApkPathField.getText().trim();
        if (apkFolder.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.missing.destination", new Object[0]));
        }
        File f = new File(apkFolder);
        if (!f.isDirectory() || !f.canWrite()) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.invalid.destination", new Object[0]));
        }
        int[] selectedFlavorIndices = this.myFlavorsList.getSelectedIndices();
        if (!this.myFlavorsListModel.isEmpty() && selectedFlavorIndices.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.missing.flavors", new Object[0]));
        }
        Object[] selectedFlavors = this.myFlavorsList.getSelectedValues();
        ArrayList<String> flavors = new ArrayList<String>(selectedFlavors.length);
        for (int i = 0; i < selectedFlavors.length; ++i) {
            flavors.add((String)selectedFlavors[i]);
        }
        this.myWizard.setApkPath(apkFolder);
        this.myWizard.setGradleOptions((String)this.myBuildTypeCombo.getSelectedItem(), flavors);
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myWizard.getProject());
        properties.setValue(PROPERTY_APK_PATH, apkFolder);
        properties.setValues(PROPERTY_FLAVORS, ArrayUtil.toStringArray(flavors));
        properties.setValue(PROPERTY_BUILD_TYPE, (String)this.myBuildTypeCombo.getSelectedItem());
    }

    public JComponent getComponent() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("APK Destination Folder:");
        jBLabel.setDisplayedMnemonic('D');
        jBLabel.setDisplayedMnemonicIndex(4);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myApkPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Build Type:");
        jBLabel2.setDisplayedMnemonic('B');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myBuildTypeCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Flavors:");
        jBLabel3.setDisplayedMnemonic('F');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 1, 2, 1, 0, 3, 3, 3, null, null, null));
        this.myFlavorsList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel4.setText("Note: Proguard settings are specified using the Project Structure Dialog");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

