/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;

public class StyleItemNameConverter
extends ResolvingConverter<String> {
    public Collection<? extends String> getVariants(ConvertContext context) {
        AttributeDefinitions attrDefs;
        ArrayList<String> result = new ArrayList<String>();
        SystemResourceManager manager = SystemResourceManager.getInstance(context);
        if (manager != null && (attrDefs = ((ResourceManager)manager).getAttributeDefinitions()) != null) {
            for (String name : attrDefs.getAttributeNames()) {
                result.add("android:" + name);
            }
        }
        return result;
    }

    public LookupElement createLookupElement(String s) {
        String prefix = "android:";
        if (s == null || !s.startsWith("android:")) {
            return null;
        }
        String attributeName = s.substring("android:".length());
        return LookupElementBuilder.create((String)s).withLookupString(attributeName);
    }

    public String fromString(String s, ConvertContext context) {
        AttributeDefinitions attrDefs;
        SystemResourceManager manager;
        if (s == null) {
            return null;
        }
        String[] strs = s.split(":");
        if (strs.length < 2 || !"android".equals(strs[0])) {
            return s;
        }
        if (strs.length == 2 && (manager = SystemResourceManager.getInstance(context)) != null && (attrDefs = ((ResourceManager)manager).getAttributeDefinitions()) != null && attrDefs.getAttrDefByName(strs[1]) != null) {
            return s;
        }
        return null;
    }

    public String toString(String s, ConvertContext context) {
        return s;
    }
}

