/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.inspections.AndroidMissingOnClickHandlerInspection;

public abstract class OnClickConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    private static final String DEFAULT_MENU_ITEM_CLASS = "android.view.MenuItem";
    private static final String ABS_MENU_ITEM_CLASS = "com.actionbarsherlock.view.MenuItem";
    public static final OnClickConverter CONVERTER_FOR_LAYOUT = new OnClickConverter(){

        @Override
        public String getDefaultMethodParameterType(PsiClass parentClass) {
            return "android.view.View";
        }

        @Override
        protected boolean isAllowedMethodParameterType(String type) {
            return "android.view.View".equals(type);
        }

        @Override
        public String getShortParameterName() {
            return "View";
        }
    };
    public static final OnClickConverter CONVERTER_FOR_MENU = new OnClickConverter(){

        @Override
        public String getDefaultMethodParameterType(PsiClass parentClass) {
            Project project = parentClass.getProject();
            PsiClass watsonClass = JavaPsiFacade.getInstance((Project)project).findClass("android.support.v4.app.Watson", GlobalSearchScope.projectScope((Project)project));
            return watsonClass != null && parentClass.isInheritor(watsonClass, true) ? OnClickConverter.ABS_MENU_ITEM_CLASS : OnClickConverter.DEFAULT_MENU_ITEM_CLASS;
        }

        @Override
        protected boolean isAllowedMethodParameterType(String type) {
            return OnClickConverter.DEFAULT_MENU_ITEM_CLASS.equals(type) || OnClickConverter.ABS_MENU_ITEM_CLASS.equals(type);
        }

        @Override
        public String getShortParameterName() {
            return "MenuItem";
        }
    };

    public abstract String getDefaultMethodParameterType(PsiClass var1);

    protected abstract boolean isAllowedMethodParameterType(String var1);

    public abstract String getShortParameterName();

    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        int length = element.getTextLength();
        if (length > 1) {
            return new PsiReference[]{new MyReference((XmlAttributeValue)element, new TextRange(1, length - 1))};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public String fromString(String s, ConvertContext context) {
        return s;
    }

    public String toString(String s, ConvertContext context) {
        return s;
    }

    public boolean checkSignature(PsiMethod method) {
        if (method.getReturnType() != PsiType.VOID) {
            return false;
        }
        if (method.hasModifierProperty("static") || method.hasModifierProperty("abstract") || !method.hasModifierProperty("public")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || aClass.isInterface()) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 1) {
            return false;
        }
        PsiType paramType = parameters[0].getType();
        if (!(paramType instanceof PsiClassType)) {
            return false;
        }
        PsiClass paramClass = ((PsiClassType)paramType).resolve();
        if (paramClass == null) {
            return false;
        }
        String paramClassName = paramClass.getQualifiedName();
        return paramClassName != null && this.isAllowedMethodParameterType(paramClassName);
    }

    public boolean findHandlerMethod(PsiClass psiClass, String methodName) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = psiClass.findMethodsByName(methodName, false)) {
            if (!this.checkSignature(method)) continue;
            return true;
        }
        return false;
    }

    private static LookupElement createLookupElement(PsiMethod method) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)method, (String)method.getName()).withIcon(method.getIcon(1)).withPresentableText(method.getName());
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null ? builder.withTailText(" (" + containingClass.getQualifiedName() + ')') : builder;
    }

    public static class MyResolveResult
    extends PsiElementResolveResult {
        private final boolean myHasCorrectSignature;

        public MyResolveResult(PsiElement element, boolean hasCorrectSignature) {
            super(element);
            this.myHasCorrectSignature = hasCorrectSignature;
        }

        public boolean hasCorrectSignature() {
            return this.myHasCorrectSignature;
        }
    }

    public class MyReference
    extends PsiPolyVariantReferenceBase<XmlAttributeValue> {
        private MyReference(XmlAttributeValue value, TextRange range) {
            super((PsiElement)value, range, true);
        }

        public ResolveResult[] multiResolve(boolean incompleteCode) {
            return ResolveCache.getInstance((Project)((XmlAttributeValue)this.myElement).getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)new ResolveCache.PolyVariantResolver<MyReference>(){

                public ResolveResult[] resolve(MyReference myReference, boolean incompleteCode) {
                    return MyReference.this.resolveInner();
                }
            }, false, incompleteCode);
        }

        private ResolveResult[] resolveInner() {
            String methodName = ((XmlAttributeValue)this.myElement).getValue();
            if (methodName == null) {
                return ResolveResult.EMPTY_ARRAY;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                return ResolveResult.EMPTY_ARRAY;
            }
            Project project = ((XmlAttributeValue)this.myElement).getProject();
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
            PsiMethod[] methods = cache.getMethodsByName(methodName, module.getModuleWithDependenciesScope());
            if (methods.length == 0) {
                return ResolveResult.EMPTY_ARRAY;
            }
            PsiClass activityBaseClass = JavaPsiFacade.getInstance((Project)project).findClass("android.app.Activity", module.getModuleWithDependenciesAndLibrariesScope(false));
            if (activityBaseClass == null) {
                return ResolveResult.EMPTY_ARRAY;
            }
            ArrayList<MyResolveResult> result = new ArrayList<MyResolveResult>();
            ArrayList<MyResolveResult> resultsWithMistake = new ArrayList<MyResolveResult>();
            for (PsiMethod method : methods) {
                PsiClass parentClass = method.getContainingClass();
                if (parentClass == null || !parentClass.isInheritor(activityBaseClass, true)) continue;
                if (OnClickConverter.this.checkSignature(method)) {
                    result.add(new MyResolveResult((PsiElement)method, true));
                    continue;
                }
                resultsWithMistake.add(new MyResolveResult((PsiElement)method, false));
            }
            return result.size() > 0 ? result.toArray(new ResolveResult[result.size()]) : resultsWithMistake.toArray(new ResolveResult[resultsWithMistake.size()]);
        }

        public Object[] getVariants() {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                return ResolveResult.EMPTY_ARRAY;
            }
            PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(module);
            if (activityClass == null) {
                return EMPTY_ARRAY;
            }
            ArrayList result = new ArrayList();
            HashSet methodNames = new HashSet();
            ClassInheritorsSearch.search((PsiClass)activityClass, (SearchScope)module.getModuleWithDependenciesScope(), (boolean)true).forEach((Processor)new Processor<PsiClass>((Set)methodNames, result){
                final /* synthetic */ Set val$methodNames;
                final /* synthetic */ List val$result;
                {
                    this.val$methodNames = set;
                    this.val$result = list;
                }

                public boolean process(PsiClass c) {
                    for (PsiMethod method : c.getMethods()) {
                        if (!OnClickConverter.this.checkSignature(method) || !this.val$methodNames.add(method.getName())) continue;
                        this.val$result.add(OnClickConverter.createLookupElement(method));
                    }
                    return true;
                }
            });
            return ArrayUtil.toObjectArray(result);
        }

        public OnClickConverter getConverter() {
            return OnClickConverter.this;
        }
    }
}

