/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LightFlagConverter
extends ResolvingConverter<String> {
    private final Set<String> myValues = new HashSet<String>();

    public LightFlagConverter(String ... values) {
        Collections.addAll(this.myValues, values);
    }

    public Collection<? extends String> getVariants(ConvertContext context) {
        String flag;
        HashSet<String> result = new HashSet<String>();
        XmlElement element = context.getXmlElement();
        if (element == null) {
            return result;
        }
        String attrValue = ((XmlAttribute)element).getValue();
        String[] flags = attrValue.split("\\|");
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < flags.length - 1 && this.myValues.contains(flag = flags[i]); ++i) {
            prefix.append(flag).append('|');
        }
        for (String value : this.myValues) {
            result.add(prefix.toString() + value);
        }
        return result;
    }

    public String fromString(String s, ConvertContext convertContext) {
        return s;
    }

    public String toString(String s, ConvertContext convertContext) {
        return s;
    }
}

