/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;

public class InstrumentationTargetPackageConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    public String fromString(String s, ConvertContext context) {
        return s;
    }

    public String toString(String s, ConvertContext context) {
        return s;
    }

    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray;
        Module module = context.getModule();
        if (element != null && module != null) {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = new MyReference(element, module);
        } else {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
        }
        return psiReferenceArray;
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement> {
        private final Module myModule;

        public MyReference(PsiElement element, Module module) {
            super(element, true);
            this.myModule = module;
        }

        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                public PsiElement resolve(PsiReference reference, boolean incompleteCode) {
                    return MyReference.this.resolveInner();
                }
            }, false, false);
        }

        private PsiElement resolveInner() {
            final String value = this.getValue();
            if (value.length() == 0) {
                return null;
            }
            final Ref result = Ref.create();
            this.processApkPackageAttrs(new Processor<GenericAttributeValue<String>>(){

                public boolean process(GenericAttributeValue<String> domValue) {
                    XmlAttributeValue xmlValue;
                    if (value.equals(domValue.getValue()) && (xmlValue = domValue.getXmlAttributeValue()) != null) {
                        result.set((Object)xmlValue);
                        return false;
                    }
                    return true;
                }
            });
            return (PsiElement)result.get();
        }

        public Object[] getVariants() {
            HashSet result = new HashSet();
            this.processApkPackageAttrs(new Processor<GenericAttributeValue<String>>((Set)result){
                final /* synthetic */ Set val$result;
                {
                    this.val$result = set;
                }

                public boolean process(GenericAttributeValue<String> domValue) {
                    String value = (String)domValue.getValue();
                    if (value != null && value.length() > 0) {
                        this.val$result.add(value);
                    }
                    return true;
                }
            });
            return ArrayUtil.toStringArray((Collection)result);
        }

        private void processApkPackageAttrs(Processor<GenericAttributeValue<String>> processor) {
            for (Module depModule : ModuleRootManager.getInstance((Module)this.myModule).getDependencies()) {
                GenericAttributeValue<String> packageAttr;
                Manifest manifest;
                AndroidFacet depFacet = AndroidFacet.getInstance(depModule);
                if (depFacet == null || depFacet.isLibraryProject() || (manifest = depFacet.getManifest()) == null || (packageAttr = manifest.getPackage()) == null || processor.process(packageAttr)) continue;
                return;
            }
        }
    }
}

