/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.google.common.collect.Lists;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;

public class CompositeConverter
extends ResolvingConverter<String> {
    private final List<ResolvingConverter<String>> myConverters;

    CompositeConverter(List<ResolvingConverter<String>> converters) {
        this.myConverters = converters;
    }

    public Collection<String> getVariants(ConvertContext context) {
        ArrayList variants = Lists.newArrayList();
        for (ResolvingConverter<String> converter : this.myConverters) {
            variants.addAll(converter.getVariants(context));
        }
        return variants;
    }

    public String fromString(String s, ConvertContext context) {
        return s;
    }

    public String toString(String s, ConvertContext context) {
        return s;
    }

    @NotThreadSafe
    public static class Builder {
        private final List<ResolvingConverter<String>> myConverters = Lists.newArrayList();
        private boolean myIsBuilt = false;

        private void assertNotBuilt() {
            if (this.myIsBuilt) {
                throw new IllegalStateException("CompositeConverterBuilder shouldn't be used after .build() is called");
            }
        }

        public void addConverter(ResolvingConverter<String> converter) {
            this.assertNotBuilt();
            this.myConverters.add(converter);
        }

        public ResolvingConverter<String> build() {
            this.assertNotBuilt();
            this.myIsBuilt = true;
            switch (this.myConverters.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.myConverters.get(0);
                }
            }
            return new CompositeConverter(this.myConverters);
        }
    }
}

