/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;

public class ApiVersionConverter
extends ResolvingConverter<String> {
    public Collection<? extends String> getVariants(ConvertContext context) {
        ArrayList<String> result = new ArrayList<String>(23);
        for (int i = 1; i <= 23; ++i) {
            if (i > 23) {
                result.add(SdkVersionInfo.getBuildCode((int)i));
                continue;
            }
            result.add(Integer.toString(i));
        }
        return result;
    }

    public LookupElement createLookupElement(String s) {
        AndroidVersion version = SdkVersionInfo.getVersion((String)s, null);
        if (version == null) {
            return null;
        }
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)s).withTypeText(version.getApiString()), (double)version.getFeatureLevel());
    }

    public String fromString(String s, ConvertContext context) {
        return s;
    }

    public String toString(String s, ConvertContext context) {
        return s;
    }
}

