/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.animation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ClassMapConstructor;

public class AndroidAnimationUtils {
    public static final String ANIMATION_PACKAGE = "android.view.animation";
    private static final String INTERPOLATOR_CLASS_NAME = "android.view.animation.Interpolator";
    private static final String[] TAG_NAMES = new String[]{"set", "alpha", "scale", "translate", "rotate", "layoutAnimation", "gridLayoutAnimation", "animation-list"};

    private AndroidAnimationUtils() {
    }

    public static String getStyleableNameByTagName(String tagName) {
        if (tagName.equals("set")) {
            return "AnimationSet";
        }
        String capitalizedTagName = StringUtil.capitalize((String)tagName);
        String suffix = "Animation";
        if (ArrayUtil.find((Object[])TAG_NAMES, (Object)tagName) >= 0 && !tagName.endsWith(suffix)) {
            return capitalizedTagName + suffix;
        }
        return capitalizedTagName;
    }

    public static List<String> getPossibleChildren(AndroidFacet facet) {
        ArrayList<String> children = new ArrayList<String>();
        Collections.addAll(children, TAG_NAMES);
        children.addAll(facet.getClassMap(INTERPOLATOR_CLASS_NAME, new ClassMapConstructor(){

            @Override
            public String[] getTagNamesByClass(PsiClass c, int apiLevel) {
                String[] stringArray;
                String name = c.getName();
                if (name != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = StringUtil.decapitalize((String)name);
                } else {
                    stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
                }
                return stringArray;
            }
        }).keySet());
        return children;
    }
}

