/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceType;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.utils.Pair;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.reference.SoftReference;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomExtension;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomExtender;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.converters.AttributeValueDocumentationProvider;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;

public class AndroidXmlDocumentationProvider
implements DocumentationProvider {
    private static final Key<SoftReference<Map<XmlName, CachedValue<String>>>> ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY = Key.create((String)"ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE");

    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof LazyValueResourceElementWrapper) {
            ValueResourceInfo info = ((LazyValueResourceElementWrapper)element).getResourceInfo();
            return "value resource '" + info.getName() + "' [" + info.getContainingFile().getName() + "]";
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        PomTarget target;
        if (element instanceof ProvidedDocumentationPsiElement) {
            return ((ProvidedDocumentationPsiElement)element).getDocumentation();
        }
        if (element instanceof LazyValueResourceElementWrapper) {
            ResourceUrl url;
            ResourceUrl originalUrl;
            LazyValueResourceElementWrapper wrapper = (LazyValueResourceElementWrapper)element;
            ValueResourceInfo resourceInfo = wrapper.getResourceInfo();
            ResourceType type = resourceInfo.getType();
            String name = resourceInfo.getName();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                return null;
            }
            AndroidFacet facet = AndroidFacet.getInstance(element);
            if (facet == null) {
                return null;
            }
            ResourceUrl resourceUrl = originalUrl = originalElement != null ? ResourceUrl.parse((String)originalElement.getText()) : null;
            if (originalUrl != null && name.equals(originalUrl.name)) {
                url = originalUrl;
            } else {
                boolean isFramework = false;
                if (originalUrl != null) {
                    isFramework = originalUrl.framework;
                } else {
                    VirtualFile resDir;
                    VirtualFile parent;
                    SystemResourceManager systemResourceManager = facet.getSystemResourceManager();
                    VirtualFile containingFile = resourceInfo.getContainingFile();
                    if (systemResourceManager != null && (parent = containingFile.getParent()) != null && (resDir = parent.getParent()) != null) {
                        isFramework = systemResourceManager.isResourceDir(resDir);
                    }
                }
                url = ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework, (boolean)false);
            }
            return AndroidXmlDocumentationProvider.generateDoc(element, url);
        }
        if (element instanceof MyResourceElement) {
            return AndroidXmlDocumentationProvider.getResourceDocumentation(element, ((MyResourceElement)element).myResource);
        }
        if (element instanceof XmlAttributeValue) {
            return AndroidXmlDocumentationProvider.getResourceDocumentation(element, ((XmlAttributeValue)element).getValue());
        }
        if (originalElement instanceof XmlToken) {
            String text;
            String documentation;
            PsiElement prev;
            XmlToken token = (XmlToken)originalElement;
            if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                PsiElement next = token.getNextSibling();
                if (next instanceof XmlToken) {
                    token = (XmlToken)next;
                }
            } else if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && (prev = token.getPrevSibling()) instanceof XmlToken) {
                token = (XmlToken)prev;
            }
            if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                String documentation2 = AndroidXmlDocumentationProvider.getResourceDocumentation(originalElement, token.getText());
                if (documentation2 != null) {
                    return documentation2;
                }
            } else if (token.getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && (documentation = AndroidXmlDocumentationProvider.getResourceDocumentation(originalElement, text = token.getText().trim())) != null) {
                return documentation;
            }
        }
        if (element instanceof PomTargetPsiElement && originalElement != null && (target = ((PomTargetPsiElement)element).getTarget()) instanceof DomAttributeChildDescription) {
            Key<SoftReference<Map<XmlName, CachedValue<String>>>> key = ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY;
            synchronized (key) {
                return AndroidXmlDocumentationProvider.generateDocForXmlAttribute((DomAttributeChildDescription)target, originalElement);
            }
        }
        if (element instanceof MyDocElement) {
            return ((MyDocElement)element).myDocumentation;
        }
        return null;
    }

    private static String getResourceDocumentation(PsiElement element, String value) {
        ResourceUrl url = ResourceUrl.parse((String)value);
        if (url != null) {
            return AndroidXmlDocumentationProvider.generateDoc(element, url);
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class, (boolean)false);
        if (attribute != null && "name".equals(attribute.getName())) {
            XmlTag tag = attribute.getParent();
            String typeName = tag.getName();
            if ("item".equals(typeName) && (typeName = tag.getAttributeValue("type")) == null) {
                return null;
            }
            ResourceType type = ResourceType.getEnum((String)typeName);
            if (type != null) {
                return AndroidXmlDocumentationProvider.generateDoc(element, type, value, false);
            }
        }
        return null;
    }

    private static String generateDocForXmlAttribute(DomAttributeChildDescription description, final PsiElement originalElement) {
        CachedValue cachedDoc;
        XmlName xmlName = description.getXmlName();
        HashMap<XmlName, CachedValue> cachedDocsMap = (HashMap<XmlName, CachedValue>)SoftReference.dereference((Reference)((Reference)originalElement.getUserData(ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY)));
        if (cachedDocsMap != null && (cachedDoc = (CachedValue)cachedDocsMap.get(xmlName)) != null) {
            return (String)cachedDoc.getValue();
        }
        final AndroidFacet facet = AndroidFacet.getInstance(originalElement);
        if (facet == null) {
            return null;
        }
        final String localName = xmlName.getLocalName();
        String namespace = xmlName.getNamespaceKey();
        if (namespace == null) {
            return null;
        }
        if ("android".equals(namespace)) {
            namespace = "http://schemas.android.com/apk/res/android";
        }
        if (namespace.startsWith("http://schemas.android.com/apk/res/")) {
            final String finalNamespace = namespace;
            CachedValue cachedValue = CachedValuesManager.getManager((Project)originalElement.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<String>(){

                public CachedValueProvider.Result<String> compute() {
                    Pair pair = AndroidXmlDocumentationProvider.findAttributeDefinition(originalElement, facet, finalNamespace, localName);
                    String doc = pair != null ? AndroidXmlDocumentationProvider.generateDocForXmlAttribute((AttributeDefinition)pair.getFirst(), (String)pair.getSecond()) : null;
                    return CachedValueProvider.Result.create((Object)doc, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            }, false);
            if (cachedDocsMap == null) {
                cachedDocsMap = new HashMap<XmlName, CachedValue>();
                originalElement.putUserData(ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY, (Object)new SoftReference(cachedDocsMap));
            }
            cachedDocsMap.put(xmlName, cachedValue);
            return (String)cachedValue.getValue();
        }
        return null;
    }

    private static Pair<AttributeDefinition, String> findAttributeDefinition(PsiElement originalElement, AndroidFacet facet, final String namespace, final String localName) {
        if (!originalElement.isValid()) {
            return null;
        }
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
        if (parentTag == null) {
            return null;
        }
        DomElement parentDomElement = DomManager.getDomManager((Project)parentTag.getProject()).getDomElement(parentTag);
        if (!(parentDomElement instanceof AndroidDomElement)) {
            return null;
        }
        final Ref result = Ref.create();
        AndroidDomExtender.processAttrsAndSubtags((AndroidDomElement)parentDomElement, new AndroidDomExtender.MyCallback(){

            @Override
            DomExtension processAttribute(XmlName xn, AttributeDefinition attrDef, String parentStyleableName) {
                if (xn.getLocalName().equals(localName) && namespace.equals(xn.getNamespaceKey())) {
                    result.set((Object)Pair.of((Object)attrDef, (Object)parentStyleableName));
                    this.stop();
                }
                return null;
            }
        }, facet, false, true);
        Pair pair = (Pair)result.get();
        if (pair != null) {
            return pair;
        }
        AttributeDefinition attrDef = AndroidXmlDocumentationProvider.findAttributeDefinitionGlobally(facet, namespace, localName);
        return attrDef != null ? Pair.of((Object)attrDef, (Object)null) : null;
    }

    private static AttributeDefinition findAttributeDefinitionGlobally(AndroidFacet facet, String namespace, String localName) {
        AttributeDefinitions attrDefs;
        ResourceManager resourceManager = "http://schemas.android.com/apk/res/android".equals(namespace) || "http://schemas.android.com/tools".equals(namespace) ? facet.getSystemResourceManager() : (namespace.equals("http://schemas.android.com/apk/res-auto") || namespace.startsWith("http://schemas.android.com/apk/res/") ? facet.getLocalResourceManager() : facet.getSystemResourceManager());
        if (resourceManager != null && (attrDefs = ((ResourceManager)resourceManager).getAttributeDefinitions()) != null) {
            return attrDefs.getAttrDefByName(localName);
        }
        return null;
    }

    private static String generateDocForXmlAttribute(AttributeDefinition definition, String parentStyleable) {
        String docValue;
        String[] values;
        StringBuilder builder = new StringBuilder("<html><body>");
        Set<AttributeFormat> formats = definition.getFormats();
        if (formats.size() > 0) {
            builder.append("Formats: ");
            ArrayList<String> formatLabels = new ArrayList<String>(formats.size());
            for (AttributeFormat format : formats) {
                formatLabels.add(format.name().toLowerCase());
            }
            Collections.sort(formatLabels);
            int n = formatLabels.size();
            for (int i = 0; i < n; ++i) {
                builder.append((String)formatLabels.get(i));
                if (i >= n - 1) continue;
                builder.append(", ");
            }
        }
        if ((values = definition.getValues()).length > 0) {
            if (builder.length() > 0) {
                builder.append("<br>");
            }
            builder.append("Values: ");
            Object[] sortedValues = new String[values.length];
            System.arraycopy(values, 0, sortedValues, 0, values.length);
            Arrays.sort(sortedValues);
            for (int i = 0; i < sortedValues.length; ++i) {
                builder.append((String)sortedValues[i]);
                if (i >= sortedValues.length - 1) continue;
                builder.append(", ");
            }
        }
        if ((docValue = definition.getDocValue(parentStyleable)) != null && docValue.length() > 0) {
            if (builder.length() > 0) {
                builder.append("<br><br>");
            }
            builder.append(docValue);
        }
        builder.append("</body></html>");
        return builder.toString();
    }

    private static String generateDoc(PsiElement originalElement, ResourceType type, String name, boolean framework) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module == null) {
            return null;
        }
        return AndroidJavaDocRenderer.render(module, type, name, framework);
    }

    private static String generateDoc(PsiElement originalElement, ResourceUrl url) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module == null) {
            return null;
        }
        return AndroidJavaDocRenderer.render(module, url);
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        String doc;
        if (object instanceof ResourceReferenceConverter.DocumentationHolder) {
            ResourceReferenceConverter.DocumentationHolder holder = (ResourceReferenceConverter.DocumentationHolder)object;
            return new ProvidedDocumentationPsiElement(psiManager, Language.ANY, holder.getValue(), holder.getDocumentation());
        }
        if (!(element instanceof XmlAttributeValue) || !(object instanceof String)) {
            return null;
        }
        String value = (String)object;
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return null;
        }
        GenericAttributeValue domValue = DomManager.getDomManager((Project)parent.getProject()).getDomElement((XmlAttribute)parent);
        if (domValue == null) {
            return null;
        }
        Converter converter = domValue.getConverter();
        if (converter instanceof AttributeValueDocumentationProvider && (doc = ((AttributeValueDocumentationProvider)converter).getDocumentation(value)) != null) {
            return new MyDocElement(element, doc);
        }
        if ((value.startsWith("@") || value.startsWith("?")) && !value.startsWith("@{")) {
            return new MyResourceElement(element, value);
        }
        return null;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    private static class MyResourceElement
    extends FakePsiElement {
        final PsiElement myParent;
        final String myResource;

        private MyResourceElement(PsiElement parent, String resource) {
            this.myParent = parent;
            this.myResource = resource;
        }

        public PsiElement getParent() {
            return this.myParent;
        }
    }

    private static class MyDocElement
    extends FakePsiElement {
        final PsiElement myParent;
        final String myDocumentation;

        private MyDocElement(PsiElement parent, String documentation) {
            this.myParent = parent;
            this.myDocumentation = documentation;
        }

        public PsiElement getParent() {
            return this.myParent;
        }
    }

    static class ProvidedDocumentationPsiElement
    extends LightElement {
        private final String myValue;
        private final String myDocumentation;

        public ProvidedDocumentationPsiElement(PsiManager manager, Language language, String value, String documentation) {
            super(manager, language);
            this.myValue = value;
            this.myDocumentation = documentation;
        }

        public String getDocumentation() {
            return this.myDocumentation;
        }

        public String toString() {
            return this.myDocumentation;
        }

        public String getText() {
            return this.myValue;
        }
    }
}

