/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.resourceManagers.FileResourceProcessor;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.android.util.ResourceFileData;

public class ResourceNamesValidityState
implements ValidityState {
    private final Map<String, ResourceFileData> myResources = new HashMap();
    private final String myAndroidTargetHashString;
    private final long myManifestTimestamp;

    public ResourceNamesValidityState(Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        IAndroidTarget target = platform != null ? platform.getTarget() : null;
        this.myAndroidTargetHashString = target != null ? target.hashString() : "";
        VirtualFile manifestFile = AndroidRootUtil.getManifestFile(facet);
        this.myManifestTimestamp = manifestFile != null ? manifestFile.getTimeStamp() : -1L;
        LocalResourceManager manager = facet.getLocalResourceManager();
        for (Pair<Resources, VirtualFile> pair : manager.getResourceElements()) {
            Resources resources = (Resources)pair.getFirst();
            VirtualFile file = (VirtualFile)pair.getSecond();
            for (ResourceType resType : AndroidResourceUtil.VALUE_RESOURCE_TYPES) {
                ResourceNamesValidityState.addValueResources(file, resType, AndroidResourceUtil.getValueResourcesFromElement(resType.getName(), resources), this.myResources, "");
            }
            ResourceNamesValidityState.addValueResources(file, ResourceType.ATTR, resources.getAttrs(), this.myResources, "");
            List<DeclareStyleable> styleables = resources.getDeclareStyleables();
            ResourceNamesValidityState.addValueResources(file, ResourceType.DECLARE_STYLEABLE, styleables, this.myResources, "");
            for (DeclareStyleable styleable : styleables) {
                String styleableName = (String)styleable.getName().getValue();
                if (styleableName == null) continue;
                ResourceNamesValidityState.addValueResources(file, ResourceType.DECLARE_STYLEABLE, styleable.getAttrs(), this.myResources, styleableName);
            }
        }
        manager.processFileResources(null, new FileResourceProcessor(){

            @Override
            public boolean process(VirtualFile resFile, String resName, String resFolderType) {
                ResourceType type = ResourceType.getEnum((String)resFolderType);
                boolean idProvidingResource = type != null && ArrayUtil.find((Object[])AndroidCommonUtils.ID_PROVIDING_RESOURCE_TYPES, (Object)type) >= 0;
                ResourceFileData data = (ResourceFileData)ResourceNamesValidityState.this.myResources.get(resFile.getPath());
                if (data == null) {
                    data = new ResourceFileData();
                    ResourceNamesValidityState.this.myResources.put(resFile.getPath(), data);
                }
                if (idProvidingResource) {
                    data.setTimestamp(resFile.getTimeStamp());
                }
                return true;
            }
        });
    }

    private static void addValueResources(VirtualFile file, ResourceType resType, Collection<? extends ResourceElement> resourceElements, Map<String, ResourceFileData> result, String context) {
        for (ResourceElement resourceElement : resourceElements) {
            String name = (String)resourceElement.getName().getValue();
            if (name == null) continue;
            ResourceFileData data = result.get(file.getPath());
            if (data == null) {
                data = new ResourceFileData();
                result.put(file.getPath(), data);
            }
            data.addValueResource(new ResourceEntry(resType.getName(), name, context));
        }
    }

    public ResourceNamesValidityState(DataInput in) throws IOException {
        this.myAndroidTargetHashString = in.readUTF();
        this.myManifestTimestamp = in.readLong();
        int resourcesCount = in.readInt();
        for (int i = 0; i < resourcesCount; ++i) {
            String filePath = in.readUTF();
            int valueResourcesCount = in.readInt();
            ArrayList<ResourceEntry> valueResources = new ArrayList<ResourceEntry>(valueResourcesCount);
            for (int j = 0; j < valueResourcesCount; ++j) {
                String resType = in.readUTF();
                String resName = in.readUTF();
                String resContext = in.readUTF();
                valueResources.add(new ResourceEntry(resType, resName, resContext));
            }
            long fileTimestamp = in.readLong();
            this.myResources.put(filePath, new ResourceFileData(valueResources, fileTimestamp));
        }
    }

    public boolean equalsTo(ValidityState otherState) {
        if (!(otherState instanceof ResourceNamesValidityState)) {
            return false;
        }
        ResourceNamesValidityState other = (ResourceNamesValidityState)otherState;
        return other.myAndroidTargetHashString.equals(this.myAndroidTargetHashString) && other.myManifestTimestamp == this.myManifestTimestamp && ((Object)other.myResources).equals(this.myResources);
    }

    public void save(DataOutput out) throws IOException {
        out.writeUTF(this.myAndroidTargetHashString);
        out.writeLong(this.myManifestTimestamp);
        out.writeInt(this.myResources.size());
        for (Map.Entry<String, ResourceFileData> entry : this.myResources.entrySet()) {
            out.writeUTF(entry.getKey());
            ResourceFileData data = entry.getValue();
            List valueResources = data.getValueResources();
            out.writeInt(valueResources.size());
            for (ResourceEntry resource : valueResources) {
                out.writeUTF(resource.getType());
                out.writeUTF(resource.getName());
                out.writeUTF(resource.getContext());
            }
            out.writeLong(data.getTimestamp());
        }
    }
}

