/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.SdkConstants;
import com.android.sdklib.IAndroidTarget;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompilerConfiguration;
import org.jetbrains.android.compiler.ClassesAndJarsValidityState;
import org.jetbrains.android.compiler.tools.AndroidDxWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.maven.AndroidMavenProvider;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;

public class AndroidDexCompiler
implements ClassPostProcessingCompiler {
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(CompileContext context) {
        return (FileProcessingCompiler.ProcessingItem[])ApplicationManager.getApplication().runReadAction((Computable)new PrepareAction(context));
    }

    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        if (!AndroidCompileUtil.isFullBuild(context)) {
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        if (items != null && items.length > 0) {
            context.getProgressIndicator().setText("Generating classes.dex...");
            return new ProcessAction(context, items).compute();
        }
        return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
    }

    public String getDescription() {
        return FileUtil.getNameWithoutExtension((String)SdkConstants.FN_DX);
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new MyValidityState(in);
    }

    public static VirtualFile getOutputDirectoryForDex(Module module) {
        VirtualFile buildDir;
        String buildDirPath;
        AndroidMavenProvider mavenProvider;
        if (AndroidMavenUtil.isMavenizedModule(module) && (mavenProvider = AndroidMavenUtil.getMavenProvider()) != null && (buildDirPath = mavenProvider.getBuildDirectory(module)) != null && (buildDir = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)buildDirPath))) != null) {
            return buildDir;
        }
        return CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
    }

    static void addModuleOutputDir(Collection<VirtualFile> files, VirtualFile dir) {
        for (VirtualFile child : dir.getChildren()) {
            if (!child.isDirectory()) continue;
            files.add(child);
        }
    }

    private static class MyValidityState
    extends ClassesAndJarsValidityState {
        private final String myAdditionalVmParams;
        private final int myMaxHeapSize;
        private final boolean myOptimize;

        public MyValidityState(Collection<VirtualFile> files, String additionalVmParams, int maxHeapSize, boolean optimize) {
            super(files);
            this.myAdditionalVmParams = additionalVmParams;
            this.myMaxHeapSize = maxHeapSize;
            this.myOptimize = optimize;
        }

        public MyValidityState(DataInput in) throws IOException {
            super(in);
            this.myAdditionalVmParams = in.readUTF();
            this.myMaxHeapSize = in.readInt();
            this.myOptimize = in.readBoolean();
        }

        @Override
        public void save(DataOutput out) throws IOException {
            super.save(out);
            out.writeUTF(this.myAdditionalVmParams);
            out.writeInt(this.myMaxHeapSize);
            out.writeBoolean(this.myOptimize);
        }

        @Override
        public boolean equalsTo(ValidityState otherState) {
            if (!super.equalsTo(otherState)) {
                return false;
            }
            if (!(otherState instanceof MyValidityState)) {
                return false;
            }
            MyValidityState state = (MyValidityState)otherState;
            return state.myAdditionalVmParams.equals(this.myAdditionalVmParams) && state.myMaxHeapSize == this.myMaxHeapSize && state.myOptimize == this.myOptimize;
        }
    }

    private static final class DexItem
    implements FileProcessingCompiler.ProcessingItem {
        final Module myModule;
        final VirtualFile myClassDir;
        final IAndroidTarget myAndroidTarget;
        final Collection<VirtualFile> myFiles;
        final String myAdditionalVmParams;
        final int myMaxHeapSize;
        final boolean myOptimize;

        public DexItem(Module module, VirtualFile classDir, IAndroidTarget target, Collection<VirtualFile> files, String additionalVmParams, int maxHeapSize, boolean optimize) {
            this.myModule = module;
            this.myClassDir = classDir;
            this.myAndroidTarget = target;
            this.myFiles = files;
            this.myAdditionalVmParams = additionalVmParams;
            this.myMaxHeapSize = maxHeapSize;
            this.myOptimize = optimize;
        }

        public VirtualFile getFile() {
            return this.myClassDir;
        }

        public ValidityState getValidityState() {
            return new MyValidityState(this.myFiles, this.myAdditionalVmParams, this.myMaxHeapSize, this.myOptimize);
        }
    }

    private static final class ProcessAction
    implements Computable<FileProcessingCompiler.ProcessingItem[]> {
        private final CompileContext myContext;
        private final FileProcessingCompiler.ProcessingItem[] myItems;

        public ProcessAction(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
            this.myContext = context;
            this.myItems = items;
        }

        public FileProcessingCompiler.ProcessingItem[] compute() {
            ArrayList<DexItem> results = new ArrayList<DexItem>(this.myItems.length);
            for (FileProcessingCompiler.ProcessingItem item : this.myItems) {
                if (!(item instanceof DexItem)) continue;
                DexItem dexItem = (DexItem)item;
                if (!AndroidCompileUtil.isModuleAffected(this.myContext, dexItem.myModule)) continue;
                String outputDirPath = FileUtil.toSystemDependentName((String)dexItem.myClassDir.getPath());
                String[] files = new String[dexItem.myFiles.size()];
                int i = 0;
                for (VirtualFile file : dexItem.myFiles) {
                    files[i++] = FileUtil.toSystemDependentName((String)file.getPath());
                }
                Map<CompilerMessageCategory, List<String>> messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidDxWrapper.execute(dexItem.myModule, dexItem.myAndroidTarget, outputDirPath, files, dexItem.myAdditionalVmParams, dexItem.myMaxHeapSize, dexItem.myOptimize));
                this.addMessages(messages, dexItem.myModule);
                if (!messages.get(CompilerMessageCategory.ERROR).isEmpty()) continue;
                results.add(dexItem);
            }
            return results.toArray(new FileProcessingCompiler.ProcessingItem[results.size()]);
        }

        private void addMessages(Map<CompilerMessageCategory, List<String>> messages, Module module) {
            for (CompilerMessageCategory category : messages.keySet()) {
                List<String> messageList = messages.get(category);
                for (String message : messageList) {
                    this.myContext.addMessage(category, '[' + module.getName() + "] " + message, null, -1, -1);
                }
            }
        }
    }

    private static final class PrepareAction
    implements Computable<FileProcessingCompiler.ProcessingItem[]> {
        private final CompileContext myContext;

        public PrepareAction(CompileContext context) {
            this.myContext = context;
        }

        public FileProcessingCompiler.ProcessingItem[] compute() {
            AndroidDexCompilerConfiguration dexConfig = AndroidDexCompilerConfiguration.getInstance(this.myContext.getProject());
            Module[] modules = ModuleManager.getInstance((Project)this.myContext.getProject()).getModules();
            ArrayList<DexItem> items = new ArrayList<DexItem>();
            for (Module module : modules) {
                HashSet files;
                boolean shouldRunProguard;
                AndroidFacet facet = (AndroidFacet)FacetManager.getInstance((Module)module).getFacetByType(AndroidFacet.ID);
                if (facet == null || facet.isLibraryProject()) continue;
                VirtualFile dexOutputDir = AndroidDexCompiler.getOutputDirectoryForDex(module);
                boolean bl = shouldRunProguard = AndroidCompileUtil.getProguardConfigFilePathIfShouldRun(facet, this.myContext) != null;
                if (shouldRunProguard) {
                    VirtualFile obfuscatedSourcesJar = dexOutputDir.findChild("obfuscated_sources.jar");
                    if (obfuscatedSourcesJar == null) {
                        this.myContext.addMessage(CompilerMessageCategory.INFORMATION, "Dex won't be launched for module " + module.getName() + " because file " + "obfuscated_sources.jar" + " doesn't exist", null, -1, -1);
                        continue;
                    }
                    files = Collections.singleton(obfuscatedSourcesJar);
                } else {
                    VirtualFile outputDirForTests;
                    CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
                    VirtualFile outputDir = extension.getCompilerOutputPath();
                    if (outputDir == null) {
                        this.myContext.addMessage(CompilerMessageCategory.INFORMATION, "Dex won't be launched for module " + module.getName() + " because it doesn't contain compiled files", null, -1, -1);
                        continue;
                    }
                    files = new HashSet();
                    AndroidDexCompiler.addModuleOutputDir((Collection<VirtualFile>)files, outputDir);
                    files.addAll(AndroidRootUtil.getExternalLibraries(module));
                    for (VirtualFile file : AndroidRootUtil.getDependentModules(module, outputDir)) {
                        if (file.isDirectory()) {
                            AndroidDexCompiler.addModuleOutputDir((Collection<VirtualFile>)files, file);
                            continue;
                        }
                        files.add(file);
                    }
                    if (facet.getProperties().PACK_TEST_CODE && (outputDirForTests = extension.getCompilerOutputPathForTests()) != null) {
                        AndroidDexCompiler.addModuleOutputDir((Collection<VirtualFile>)files, outputDirForTests);
                    }
                }
                AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
                AndroidPlatform platform = configuration.getAndroidPlatform();
                if (platform == null) {
                    this.myContext.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
                    continue;
                }
                items.add(new DexItem(module, dexOutputDir, platform.getTarget(), (Collection<VirtualFile>)files, dexConfig.VM_OPTIONS, dexConfig.MAX_HEAP_SIZE, dexConfig.OPTIMIZE));
            }
            return items.toArray(new FileProcessingCompiler.ProcessingItem[items.size()]);
        }
    }
}

