/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SdkResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.android.augment.AndroidInternalRClass;
import org.jetbrains.android.sdk.AndroidSdkType;

public class AndroidSdkResolveScopeProvider
extends SdkResolveScopeProvider {
    public GlobalSearchScope getScope(Project project, JdkOrderEntry entry) {
        Sdk sdk = entry.getJdk();
        if (sdk == null || !(sdk.getSdkType() instanceof AndroidSdkType)) {
            return null;
        }
        if (sdk.getRootProvider().getFiles(OrderRootType.SOURCES).length == 0) {
            return null;
        }
        return new MyJdkScope(project, entry);
    }

    public static class MyJdkScope
    extends JdkScope {
        private final Sdk mySdk;

        private MyJdkScope(Project project, JdkOrderEntry jdkOrderEntry) {
            super(project, jdkOrderEntry);
            this.mySdk = jdkOrderEntry.getJdk();
        }

        public boolean isForceSearchingInLibrarySources() {
            return true;
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            boolean inSources1 = this.myIndex.isInLibrarySource(file1);
            if (inSources1 != this.myIndex.isInLibrarySource(file2) && !"Object".equals(file1.getNameWithoutExtension())) {
                return inSources1 ? 1 : -1;
            }
            return super.compare(file1, file2);
        }

        public boolean contains(VirtualFile file) {
            return super.contains(file) || AndroidInternalRClass.isAndroidInternalR(file, this.mySdk);
        }
    }
}

