/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.sdklib.IAndroidTarget;
import com.intellij.ProjectTopics;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.importDependencies.ImportDependenciesUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;

public class AndroidPropertyFilesUpdater
extends AbstractProjectComponent {
    private static final NotificationGroup PROPERTY_FILES_UPDATING_NOTIFICATION = NotificationGroup.balloonGroup((String)"Android Property Files Updating");
    private static final Key<List<Object>> ANDROID_PROPERTIES_STATE_KEY = Key.create((String)"ANDROID_PROPERTIES_STATE");
    private Notification myNotification;

    protected AndroidPropertyFilesUpdater(Project project) {
        super(project);
    }

    public void initComponent() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.addProjectPropertiesUpdatingListener();
        }
    }

    public void disposeComponent() {
        if (this.myNotification != null && !this.myNotification.isExpired()) {
            this.myNotification.expire();
        }
    }

    private void addProjectPropertiesUpdatingListener() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StartupManager.getInstance((Project)AndroidPropertyFilesUpdater.this.myProject).runWhenProjectIsInitialized(new Runnable(){

                            @Override
                            public void run() {
                                AndroidPropertyFilesUpdater.this.updatePropertyFilesIfNecessary();
                            }
                        });
                    }
                }, AndroidPropertyFilesUpdater.this.myProject.getDisposed());
            }
        });
    }

    private void updatePropertyFilesIfNecessary() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        final ArrayList<Object> toAskFiles = new ArrayList<Object>();
        final ArrayList<AndroidFacet> toAskFacets = new ArrayList<AndroidFacet>();
        final ArrayList toAskChanges = new ArrayList();
        ArrayList<Object> files = new ArrayList<Object>();
        final ArrayList changes = new ArrayList();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            Pair<VirtualFile, List<Runnable>> pair;
            String updatePropertyFiles;
            boolean ask;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || facet.requiresAndroidModel() || !(ask = (updatePropertyFiles = facet.getProperties().UPDATE_PROPERTY_FILES).isEmpty()) && !Boolean.parseBoolean(updatePropertyFiles) || (pair = AndroidPropertyFilesUpdater.updateProjectPropertiesIfNecessary(facet)) == null) continue;
            if (ask) {
                toAskFacets.add(facet);
                toAskFiles.add(pair.getFirst());
                toAskChanges.addAll((Collection)pair.getSecond());
                continue;
            }
            files.add(pair.getFirst());
            changes.addAll((Collection)pair.getSecond());
        }
        if (this.myNotification != null && !this.myNotification.isExpired()) {
            this.myNotification.expire();
        }
        if (changes.size() > 0 || toAskChanges.size() > 0) {
            if (toAskChanges.size() > 0) {
                this.askUserIfUpdatePropertyFile(this.myProject, toAskFacets, new Processor<MyResult>(){

                    public boolean process(MyResult result) {
                        if (result == MyResult.NEVER) {
                            for (AndroidFacet facet : toAskFacets) {
                                facet.getProperties().UPDATE_PROPERTY_FILES = Boolean.FALSE.toString();
                            }
                            return true;
                        }
                        if (result == MyResult.ALWAYS) {
                            for (AndroidFacet facet : toAskFacets) {
                                facet.getProperties().UPDATE_PROPERTY_FILES = Boolean.TRUE.toString();
                            }
                        }
                        if (ReadonlyStatusHandler.ensureFilesWritable((Project)AndroidPropertyFilesUpdater.this.myProject, (VirtualFile[])toAskFiles.toArray(new VirtualFile[toAskFiles.size()]))) {
                            CommandProcessor.getInstance().executeCommand(AndroidPropertyFilesUpdater.this.myProject, new Runnable(){

                                @Override
                                public void run() {
                                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                        @Override
                                        public void run() {
                                            for (Runnable change : toAskChanges) {
                                                change.run();
                                            }
                                        }
                                    });
                                }
                            }, "Update Android property files", null);
                        }
                        return true;
                    }
                });
            }
            if (changes.size() > 0 && ReadonlyStatusHandler.ensureFilesWritable((Project)this.myProject, (VirtualFile[])files.toArray(new VirtualFile[files.size()]))) {
                CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                for (Runnable change : changes) {
                                    change.run();
                                }
                            }
                        });
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(AndroidPropertyFilesUpdater.this.myProject);
                    }
                }, "Update Android property files", null);
            }
        }
    }

    private static Pair<VirtualFile, List<Runnable>> updateProjectPropertiesIfNecessary(AndroidFacet facet) {
        if (facet.isDisposed()) {
            return null;
        }
        Module module = facet.getModule();
        Pair<PropertiesFile, VirtualFile> pair = AndroidRootUtil.findPropertyFile(module, "project.properties");
        if (pair == null) {
            return null;
        }
        PropertiesFile projectProperties = (PropertiesFile)pair.getFirst();
        VirtualFile projectPropertiesVFile = (VirtualFile)pair.getSecond();
        Pair<Properties, VirtualFile> localProperties = AndroidRootUtil.readPropertyFile(module, "local.properties");
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        IAndroidTarget androidTarget = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidTarget();
        String androidTargetHashString = androidTarget != null ? androidTarget.hashString() : null;
        VirtualFile[] dependencies = AndroidPropertyFilesUpdater.collectDependencies(module);
        String[] dependencyPaths = AndroidPropertyFilesUpdater.toSortedPaths(dependencies);
        List<Object> newState = Arrays.asList(androidTargetHashString, facet.isLibraryProject(), Arrays.asList(dependencyPaths), facet.getProperties().ENABLE_MANIFEST_MERGING, facet.getProperties().ENABLE_PRE_DEXING);
        List state = (List)facet.getUserData(ANDROID_PROPERTIES_STATE_KEY);
        if (state == null || !Comparing.equal((Object)state, newState)) {
            AndroidPropertyFilesUpdater.updateTargetProperty(facet, projectProperties, changes);
            AndroidPropertyFilesUpdater.updateLibraryProperty(facet, projectProperties, changes);
            AndroidPropertyFilesUpdater.updateManifestMergerProperty(facet, projectProperties, changes);
            AndroidPropertyFilesUpdater.updateDependenciesInPropertyFile(projectProperties, localProperties, dependencies, changes);
            facet.putUserData(ANDROID_PROPERTIES_STATE_KEY, newState);
        }
        return changes.size() > 0 ? Pair.create((Object)projectPropertiesVFile, changes) : null;
    }

    private static void updateDependenciesInPropertyFile(final PropertiesFile projectProperties, Pair<Properties, VirtualFile> localProperties, VirtualFile[] dependencies, List<Runnable> changes) {
        VirtualFile vFile = projectProperties.getVirtualFile();
        if (vFile == null) {
            return;
        }
        Set<Object> localDependencies = localProperties != null ? ImportDependenciesUtil.getLibDirs(localProperties) : Collections.emptySet();
        VirtualFile baseDir = vFile.getParent();
        String baseDirPath = baseDir.getPath();
        final ArrayList<String> newDepValues = new ArrayList<String>();
        for (VirtualFile dependency : dependencies) {
            if (localDependencies.contains(dependency)) continue;
            String relPath = FileUtil.getRelativePath((String)baseDirPath, (String)dependency.getPath(), (char)'/');
            String value = relPath != null ? relPath : dependency.getPath();
            newDepValues.add(value);
        }
        HashSet oldDepValues = new HashSet();
        for (IProperty property : projectProperties.getProperties()) {
            String name = property.getName();
            if (name == null || !name.startsWith("android.library.reference.")) continue;
            oldDepValues.add(property.getValue());
        }
        if (!new HashSet(newDepValues).equals((Object)oldDepValues)) {
            changes.add(new Runnable(){

                @Override
                public void run() {
                    for (IProperty property : projectProperties.getProperties()) {
                        String name = property.getName();
                        if (name == null || !name.startsWith("android.library.reference.")) continue;
                        property.getPsiElement().delete();
                    }
                    for (int i = 0; i < newDepValues.size(); ++i) {
                        String value = (String)newDepValues.get(i);
                        projectProperties.addProperty("android.library.reference." + Integer.toString(i + 1), value);
                    }
                }
            });
        }
    }

    private static VirtualFile[] collectDependencies(Module module) {
        ArrayList<VirtualFile> dependenciesList = new ArrayList<VirtualFile>();
        for (AndroidFacet depFacet : AndroidUtils.getAndroidLibraryDependencies(module)) {
            Module depModule = depFacet.getModule();
            VirtualFile libDir = AndroidPropertyFilesUpdater.getBaseAndroidContentRoot(depModule);
            if (libDir == null) continue;
            dependenciesList.add(libDir);
        }
        return dependenciesList.toArray(new VirtualFile[dependenciesList.size()]);
    }

    private static void updateTargetProperty(AndroidFacet facet, final PropertiesFile propertiesFile, List<Runnable> changes) {
        final Project project = facet.getModule().getProject();
        IAndroidTarget androidTarget = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidTarget();
        if (androidTarget != null) {
            PsiElement element;
            final String targetPropertyValue = androidTarget.hashString();
            IProperty property = propertiesFile.findPropertyByKey("target");
            if (property == null) {
                changes.add(new Runnable(){

                    @Override
                    public void run() {
                        propertiesFile.addProperty(AndroidPropertyFilesUpdater.createProperty(project, targetPropertyValue));
                    }
                });
            } else if (!Comparing.equal((String)property.getValue(), (String)targetPropertyValue) && (element = property.getPsiElement()) != null) {
                changes.add(new Runnable(){

                    @Override
                    public void run() {
                        element.replace(AndroidPropertyFilesUpdater.createProperty(project, targetPropertyValue).getPsiElement());
                    }
                });
            }
        }
    }

    public static void updateLibraryProperty(AndroidFacet facet, final PropertiesFile propertiesFile, List<Runnable> changes) {
        final IProperty property = propertiesFile.findPropertyByKey("android.library");
        if (property != null) {
            final String value = Boolean.toString(facet.isLibraryProject());
            if (!value.equals(property.getValue())) {
                changes.add(new Runnable(){

                    @Override
                    public void run() {
                        property.setValue(value);
                    }
                });
            }
        } else if (facet.isLibraryProject()) {
            changes.add(new Runnable(){

                @Override
                public void run() {
                    propertiesFile.addProperty("android.library", Boolean.TRUE.toString());
                }
            });
        }
    }

    public static void updateManifestMergerProperty(AndroidFacet facet, final PropertiesFile propertiesFile, List<Runnable> changes) {
        final IProperty property = propertiesFile.findPropertyByKey("manifestmerger.enabled");
        if (property != null) {
            final String value = Boolean.toString(facet.getProperties().ENABLE_MANIFEST_MERGING);
            if (!value.equals(property.getValue())) {
                changes.add(new Runnable(){

                    @Override
                    public void run() {
                        property.setValue(value);
                    }
                });
            }
        } else if (facet.getProperties().ENABLE_MANIFEST_MERGING) {
            changes.add(new Runnable(){

                @Override
                public void run() {
                    propertiesFile.addProperty("manifestmerger.enabled", Boolean.TRUE.toString());
                }
            });
        } else if (!facet.getProperties().ENABLE_PRE_DEXING) {
            changes.add(new Runnable(){

                @Override
                public void run() {
                    propertiesFile.addProperty("dex.disable.merger", Boolean.TRUE.toString());
                }
            });
        }
    }

    private static VirtualFile getBaseAndroidContentRoot(Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        VirtualFile manifestFile = facet != null ? AndroidRootUtil.getManifestFile(facet) : null;
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (manifestFile != null) {
            for (VirtualFile contentRoot : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)manifestFile, (boolean)true)) continue;
                return contentRoot;
            }
        }
        return contentRoots.length > 0 ? contentRoots[0] : null;
    }

    private static IProperty createProperty(Project project, String targetPropertyValue) {
        String text = "target=" + targetPropertyValue;
        PropertiesFile dummyFile = PropertiesElementFactory.createPropertiesFile((Project)project, (String)text);
        return (IProperty)dummyFile.getProperties().get(0);
    }

    private static String[] toSortedPaths(VirtualFile[] files) {
        Object[] result = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i].getPath();
        }
        Arrays.sort(result);
        return result;
    }

    private void askUserIfUpdatePropertyFile(Project project, Collection<AndroidFacet> facets, final Processor<MyResult> callback) {
        StringBuilder moduleList = new StringBuilder();
        for (AndroidFacet facet : facets) {
            moduleList.append(facet.getModule().getName()).append("<br>");
        }
        this.myNotification = PROPERTY_FILES_UPDATING_NOTIFICATION.createNotification(AndroidBundle.message("android.update.project.properties.dialog.title", new Object[0]), AndroidBundle.message("android.update.project.properties.dialog.text", moduleList.toString()), NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(Notification notification, HyperlinkEvent event) {
                String desc = event.getDescription();
                if ("once".equals(desc)) {
                    callback.process((Object)MyResult.ONCE);
                } else if ("never".equals(desc)) {
                    callback.process((Object)MyResult.NEVER);
                } else {
                    callback.process((Object)MyResult.ALWAYS);
                }
                notification.expire();
            }
        });
        this.myNotification.notify(project);
    }

    private static enum MyResult {
        ONCE,
        NEVER,
        ALWAYS;

    }
}

