/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.lang.aidl.AidlFileType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import icons.AndroidIcons;
import java.util.Properties;

public class AndroidFileTemplateProvider
implements FileTemplateGroupDescriptorFactory {
    public static final String REMOTE_INTERFACE_TEMPLATE = "Remote_Interface.aidl";
    public static final String ANDROID_MANIFEST_TEMPLATE = "AndroidManifest.xml";
    public static final String VALUE_RESOURCE_FILE_TEMPLATE = "valueResourceFile.xml";
    public static final String RESOURCE_FILE_TEMPLATE = "resourceFile.xml";
    public static final String LAYOUT_RESOURCE_FILE_TEMPLATE = "layoutResourceFile.xml";
    public static final String LAYOUT_RESOURCE_VERTICAL_FILE_TEMPLATE = "layoutResourceFile_vertical.xml";
    public static final String ACTIVITY = "Activity.java";
    public static final String FRAGMENT = "Fragment.java";
    public static final String APPLICATION = "Application.java";
    public static final String SERVICE = "Service.java";
    public static final String BROADCAST_RECEIVER = "Broadcast_Receiver.java";
    public static final String DEFAULT_PROPERTIES_TEMPLATE = "default.properties";

    public FileTemplateGroupDescriptor getFileTemplatesDescriptor() {
        FileTemplateGroupDescriptor group = new FileTemplateGroupDescriptor("Android", AndroidIcons.Android);
        group.addTemplate(new FileTemplateDescriptor(ANDROID_MANIFEST_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(VALUE_RESOURCE_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(RESOURCE_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(LAYOUT_RESOURCE_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(LAYOUT_RESOURCE_VERTICAL_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(ACTIVITY, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(FRAGMENT, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(APPLICATION, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(SERVICE, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(BROADCAST_RECEIVER, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(REMOTE_INTERFACE_TEMPLATE, AidlFileType.INSTANCE.getIcon()));
        return group;
    }

    public static PsiElement createFromTemplate(Project project, VirtualFile rootDir, String templateName, String fileName, Properties properties) throws Exception {
        rootDir.refresh(false, false);
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(rootDir);
        if (directory != null) {
            return AndroidFileTemplateProvider.createFromTemplate(templateName, fileName, directory, properties);
        }
        return null;
    }

    public static PsiElement createFromTemplate(Project project, VirtualFile rootDir, String templateName, String fileName) throws Exception {
        return AndroidFileTemplateProvider.createFromTemplate(project, rootDir, templateName, fileName, FileTemplateManager.getInstance((Project)project).getDefaultProperties());
    }

    public static PsiElement createFromTemplate(String templateName, String fileName, PsiDirectory directory, Properties properties) throws Exception {
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)directory.getProject());
        FileTemplate template = manager.getJ2eeTemplate(templateName);
        return FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)directory);
    }

    public static PsiElement createFromTemplate(String templateName, String fileName, PsiDirectory directory) throws Exception {
        return AndroidFileTemplateProvider.createFromTemplate(templateName, fileName, directory, FileTemplateManager.getInstance((Project)directory.getProject()).getDefaultProperties());
    }

    public static String getFileNameByNewElementName(String name) {
        if (!FileUtilRt.extensionEquals((String)name, (String)"xml")) {
            name = name + ".xml";
        }
        return name;
    }
}

