/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.relative.RadRelativeLayoutComponent;
import com.intellij.android.designer.model.layout.relative.RelativeLayoutDropOperation;
import com.intellij.android.designer.propertyTable.AttributeProperty;
import com.intellij.android.designer.propertyTable.editors.ComponentEditor;
import com.intellij.android.designer.propertyTable.renderers.ComponentRenderer;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;

public class RelativeIdAttributeProperty
extends AttributeProperty {
    public RelativeIdAttributeProperty(AttributeProperty property) {
        super(property.getParent(), property.getName(), property.myDefinition);
    }

    private static ComponentRenderer createRenderer() {
        return new ComponentRenderer(){

            @Override
            public RadComponent getComponentById(RadComponent component, String value) {
                String componentId = RadRelativeLayoutComponent.parseIdValue(value);
                if (componentId != null) {
                    for (RadComponent childComponent : component.getParent().getChildren()) {
                        String childComponentId = ((RadViewComponent)childComponent).getId();
                        if (childComponentId == null || !componentId.equals(RadRelativeLayoutComponent.parseIdValue(childComponentId))) continue;
                        return childComponent;
                    }
                }
                return null;
            }
        };
    }

    @Override
    protected PropertyRenderer createResourceRenderer(AttributeDefinition definition, Set<AttributeFormat> formats) {
        return RelativeIdAttributeProperty.createRenderer();
    }

    @Override
    protected PropertyEditor createResourceEditor(final AttributeDefinition definition, Set<AttributeFormat> formats) {
        return new ComponentEditor(RelativeIdAttributeProperty.createRenderer()){

            @Override
            protected List<RadComponent> getComponents(RadComponent component) {
                RadComponent layout = component.getParent();
                List<RadViewComponent> views = Arrays.asList((RadViewComponent)component);
                return RelativeLayoutDropOperation.getValidTargets(definition.getName(), (RadViewComponent)layout, views);
            }
        };
    }

    public boolean availableFor(List<PropertiesContainer> components) {
        return false;
    }
}

