/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.IPropertyDecorator;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import java.util.ArrayList;
import java.util.List;

public class CompoundProperty
extends Property<RadViewComponent>
implements IPropertyDecorator,
IXmlAttributeLocator {
    private final List<Property<RadViewComponent>> myChildren = new ArrayList<Property<RadViewComponent>>();
    private PropertyRenderer myRenderer;

    public CompoundProperty(String name) {
        super(null, name);
    }

    public Property<RadViewComponent> createForNewPresentation(Property parent, String name) {
        CompoundProperty property = this.createForNewPresentation(name);
        List<Property<RadViewComponent>> children = property.getChildren((RadViewComponent)null);
        for (Property<RadViewComponent> childProperty : this.myChildren) {
            children.add((Property<RadViewComponent>)childProperty.createForNewPresentation((Property)property, childProperty.getName()));
        }
        return property;
    }

    public void decorate(MetaModel model) {
        String name = this.getName();
        model.decorate0((Property)this, name);
        for (Property<RadViewComponent> childProperty : this.myChildren) {
            model.decorate(childProperty, name + "." + childProperty.getName());
        }
    }

    public List<Property<RadViewComponent>> getChildren(RadViewComponent component) {
        return this.myChildren;
    }

    protected CompoundProperty createForNewPresentation(String name) {
        return new CompoundProperty(name);
    }

    public Object getValue(RadViewComponent component) throws Exception {
        StringBuilder value = new StringBuilder();
        int index = 0;
        int empty = 0;
        for (Property<RadViewComponent> childProperty : this.myChildren) {
            String childValue;
            if (index++ > 0) {
                value.append(", ");
            }
            if (StringUtil.isEmpty((String)(childValue = (String)childProperty.getValue((PropertiesContainer)component)))) {
                ++empty;
                value.append("?");
                continue;
            }
            value.append(childValue);
        }
        if (empty == this.myChildren.size()) {
            return "";
        }
        return value.toString();
    }

    public void setDefaultValue(RadViewComponent component) throws Exception {
        for (Property<RadViewComponent> childProperty : this.myChildren) {
            childProperty.setDefaultValue((PropertiesContainer)component);
        }
    }

    public PropertyRenderer getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new LabelPropertyRenderer(null);
        }
        return this.myRenderer;
    }

    public PropertyEditor getEditor() {
        return null;
    }

    public String getJavadocText() {
        return this.myChildren.isEmpty() ? null : this.myChildren.get(0).getJavadocText();
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        for (Property<RadViewComponent> childProperty : this.myChildren) {
            if (!((IXmlAttributeLocator)childProperty).checkAttribute(component, attribute)) continue;
            return true;
        }
        return false;
    }
}

