/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.actions;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.actions.LayoutAction;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import javax.swing.Icon;

public class ToggleSizeAction
extends LayoutAction {
    private final List<? extends RadViewComponent> myComponents;
    private final String myAttribute;
    private final Icon myFillIcon;
    private final Icon myWrapIcon;

    public ToggleSizeAction(DesignerEditorPanel designer, List<? extends RadViewComponent> components, String label, String attribute, Icon fillIcon, Icon wrapIcon) {
        super(designer, label, null, null);
        this.myComponents = components;
        this.myAttribute = attribute;
        this.myFillIcon = fillIcon;
        this.myWrapIcon = wrapIcon;
        this.updateLabel(this.getTemplatePresentation(), this.isFill());
    }

    private boolean isFill() {
        XmlTag tag = this.myComponents.get(0).getTag();
        String value = tag.getAttributeValue(this.myAttribute, "http://schemas.android.com/apk/res/android");
        return "match_parent".equals(value) || "fill_parent".equals(value);
    }

    private void updateLabel(Presentation presentation, boolean isFill) {
        presentation.setIcon(isFill ? this.myFillIcon : this.myWrapIcon);
        String text = String.format("Set %1$s to %2$s", this.myAttribute, isFill ? "wrap_content" : "match_parent");
        presentation.setDescription(text);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        boolean isFill = this.isFill();
        this.updateLabel(e.getPresentation(), !isFill);
        super.actionPerformed(e);
    }

    @Override
    protected void performWriteAction() {
        boolean isFill = this.isFill();
        for (RadViewComponent radViewComponent : this.myComponents) {
            XmlTag tag = radViewComponent.getTag();
            if (isFill) {
                tag.setAttribute(this.myAttribute, "http://schemas.android.com/apk/res/android", "wrap_content");
                continue;
            }
            tag.setAttribute(this.myAttribute, "http://schemas.android.com/apk/res/android", "match_parent");
        }
    }
}

