/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.actions;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.actions.LayoutAction;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import icons.AndroidDesignerIcons;

public class BaselineAction
extends LayoutAction {
    private final RadViewComponent myLayout;
    private boolean myAlign;

    public BaselineAction(DesignerEditorPanel designer, RadViewComponent layout) {
        super(designer, "Toggle baselineAligned", null, null);
        this.myAlign = BaselineAction.isBaselineAligned(layout);
        this.myLayout = layout;
        Presentation presentation = this.getTemplatePresentation();
        this.updatePresentation(presentation);
    }

    private static boolean isBaselineAligned(RadViewComponent component) {
        XmlTag tag = component.getTag();
        XmlAttribute attribute = tag.getAttribute("baselineAligned", "http://schemas.android.com/apk/res/android");
        if (attribute != null) {
            String value = attribute.getValue();
            return Boolean.valueOf(value);
        }
        return true;
    }

    private void updatePresentation(Presentation presentation) {
        presentation.setIcon(this.myAlign ? AndroidDesignerIcons.Baseline : AndroidDesignerIcons.NoBaseline);
        presentation.setDescription(this.myAlign ? "Align with the baseline" : "Do not align with the baseline");
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        this.myAlign = !this.myAlign;
        this.updatePresentation(e.getPresentation());
        super.actionPerformed(e);
    }

    @Override
    protected void performWriteAction() {
        XmlTag tag = this.myLayout.getTag();
        if (this.myAlign) {
            XmlAttribute attribute = tag.getAttribute("baselineAligned", "http://schemas.android.com/apk/res/android");
            if (attribute != null) {
                attribute.delete();
            }
        } else {
            tag.setAttribute("baselineAligned", "http://schemas.android.com/apk/res/android", "false");
        }
    }
}

