/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout;

import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.designer.SegmentType;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;

public enum TextDirection {
    LEFT_TO_RIGHT,
    RIGHT_TO_LEFT;


    public static TextDirection fromAndroidDesignerEditorPanel(AndroidDesignerEditorPanel panel) {
        Configuration configuration;
        Configuration configuration2 = configuration = panel != null ? panel.getConfiguration() : null;
        if (configuration == null) {
            return LEFT_TO_RIGHT;
        }
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        return qualifier == null || qualifier.getValue() != LayoutDirection.RTL ? LEFT_TO_RIGHT : RIGHT_TO_LEFT;
    }

    public SegmentType getLeftSegment() {
        return this == LEFT_TO_RIGHT ? SegmentType.START : SegmentType.END;
    }

    public SegmentType getRightSegment() {
        return this == LEFT_TO_RIGHT ? SegmentType.END : SegmentType.START;
    }

    public boolean isLeftSegment(SegmentType type) {
        return type == SegmentType.LEFT || type == this.getLeftSegment();
    }

    public boolean isRightSegment(SegmentType type) {
        return type == SegmentType.RIGHT || type == this.getRightSegment();
    }

    public String getAttrLeft() {
        return this == LEFT_TO_RIGHT ? "layout_alignStart" : "layout_alignEnd";
    }

    public String getAttrLeftOf() {
        return this == LEFT_TO_RIGHT ? "layout_toStartOf" : "layout_toEndOf";
    }

    public String getAttrRight() {
        return this == LEFT_TO_RIGHT ? "layout_alignEnd" : "layout_alignStart";
    }

    public String getAttrRightOf() {
        return this == LEFT_TO_RIGHT ? "layout_toEndOf" : "layout_toStartOf";
    }

    public String getAttrAlignParentLeft() {
        return this == LEFT_TO_RIGHT ? "layout_alignParentStart" : "layout_alignParentEnd";
    }

    public String getAttrAlignParentRight() {
        return this == LEFT_TO_RIGHT ? "layout_alignParentEnd" : "layout_alignParentStart";
    }

    public String getAttrMarginLeft() {
        return this == LEFT_TO_RIGHT ? "layout_marginStart" : "layout_marginEnd";
    }

    public String getAttrMarginRight() {
        return this == LEFT_TO_RIGHT ? "layout_marginEnd" : "layout_marginStart";
    }
}

