/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.RenderService;
import com.intellij.android.designer.AndroidDesignerEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jdom.Element;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;

public final class AndroidDesignerEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String ANDROID_DESIGNER_ID = "android-designer";

    public static boolean acceptLayout(Project project, VirtualFile file) {
        if (RenderService.NELE_ENABLED) {
            return false;
        }
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, file);
        return psiFile instanceof XmlFile && AndroidFacet.getInstance((PsiElement)psiFile) != null && LayoutDomFileDescription.isLayoutFile((XmlFile)psiFile);
    }

    public boolean accept(Project project, VirtualFile file) {
        return AndroidDesignerEditorProvider.acceptLayout(project, file);
    }

    public FileEditor createEditor(Project project, VirtualFile file) {
        return new AndroidDesignerEditor(project, file);
    }

    public void disposeEditor(FileEditor editor) {
        Disposer.dispose((Disposable)editor);
    }

    public FileEditorState readState(Element sourceElement, Project project, VirtualFile file) {
        return FileEditorState.INSTANCE;
    }

    public void writeState(FileEditorState state, Project project, Element targetElement) {
    }

    public String getEditorTypeId() {
        return ANDROID_DESIGNER_ID;
    }

    public FileEditorPolicy getPolicy() {
        return AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor() ? FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR : FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }
}

