/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.idea.ui.ImageComponent;
import com.android.tools.idea.wizard.WizardConstants;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class WizardStepHeaderPanel
extends JPanel {
    String myTitle = "Title Label";
    String myDescription;
    Icon myWizardIcon;
    Icon myStepIcon;
    private JLabel myTitleLabel;
    private ComponentHolder<String, JLabel> myDescriptionLabel = new LabelHolder();
    private ComponentHolder<Icon, ImageComponent> myWizardIconComponent = new ImageComponentHolder();
    private ComponentHolder<Icon, ImageComponent> myStepIconComponent = new ImageComponentHolder();

    public WizardStepHeaderPanel() {
        this.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        this.setForeground(Color.WHITE);
        this.setBackground((Color)WizardConstants.ANDROID_NPW_HEADER_COLOR);
        this.updateHeader();
    }

    private static GridConstraints createHeaderLabelGridConstraints(int row, int column, int anchor) {
        return new GridConstraints(row, column, 1, 1, anchor, 1, 6, 0, null, null, null);
    }

    public static WizardStepHeaderPanel create(final JBColor headerColor, Icon wizardIcon, Icon stepIcon, String title, String description) {
        final WizardStepHeaderPanel panel = new WizardStepHeaderPanel();
        panel.setBackground((Color)headerColor);
        panel.setTitle(title);
        panel.setDescription(description);
        panel.setStepIcon(stepIcon);
        panel.setWizardIcon(wizardIcon);
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JBColor.setDark((boolean)UIUtil.isUnderDarcula());
                panel.setBackground((Color)headerColor);
                Font font = UIManager.getFont("Label.font");
                panel.myTitleLabel.setFont(new Font(font.getFontName(), font.getStyle(), 24));
            }
        });
        return panel;
    }

    public void setTitle(String title) {
        this.myTitle = StringUtil.notNullize((String)title, (String)"Title Label");
        this.updateHeader();
    }

    public void setDescription(String description) {
        this.myDescription = description;
        this.updateHeader();
    }

    public void setStepIcon(Icon stepIcon) {
        this.myStepIcon = stepIcon;
        this.updateHeader();
    }

    public void setWizardIcon(Icon wizardIcon) {
        this.myWizardIcon = wizardIcon;
        this.updateHeader();
    }

    private void updateHeader() {
        boolean updateLayout = false;
        if (this.myTitleLabel == null) {
            this.myTitleLabel = new JLabel(this.myTitle);
            updateLayout = true;
        }
        this.myTitleLabel.setText(this.myTitle);
        if (updateLayout |= this.myDescriptionLabel.updateValue(StringUtil.nullize((String)this.myDescription, (boolean)true)) || this.myWizardIconComponent.updateValue(this.myWizardIcon) || this.myStepIconComponent.updateValue(this.myStepIcon)) {
            int rows = this.myDescriptionLabel.getComponent() == null ? 1 : 2;
            int columns = 1 + (this.myWizardIconComponent.getComponent() == null ? 0 : 1) + (this.myStepIconComponent.getComponent() == null ? 0 : 1);
            for (Component component : this.getComponents()) {
                this.remove(component);
            }
            this.setLayout((LayoutManager)new GridLayoutManager(rows, columns, new Insets(18, 0, 12, 0), 2, 2));
            int currentColumn = this.addIconIfExists(this.myWizardIconComponent.getComponent(), 0, rows) ? 1 : 0;
            this.addLabels(this.myTitleLabel, this.myDescriptionLabel.getComponent(), currentColumn);
            this.addIconIfExists(this.myStepIconComponent.getComponent(), currentColumn + 1, rows);
        }
    }

    private void addLabels(JLabel titleLabel, JLabel descriptionLabel, int column) {
        boolean hasDescription = descriptionLabel != null;
        int anchor = hasDescription ? 10 : 8;
        titleLabel.setForeground(this.getForeground());
        titleLabel.setFont(titleLabel.getFont().deriveFont(JBUI.scale((float)24.0f)));
        this.add((Component)titleLabel, WizardStepHeaderPanel.createHeaderLabelGridConstraints(0, column, anchor));
        if (hasDescription) {
            descriptionLabel.setForeground(this.getForeground());
            this.add((Component)descriptionLabel, WizardStepHeaderPanel.createHeaderLabelGridConstraints(1, column, 9));
        }
    }

    private boolean addIconIfExists(ImageComponent iconComponent, int column, int spanningRows) {
        if (iconComponent != null) {
            GridConstraints imageConstraints = new GridConstraints(0, column, spanningRows, 1, 9, 0, 0, 0, null, (Dimension)JBUI.size((int)60, (int)60), null);
            this.add((Component)((Object)iconComponent), imageConstraints);
            return true;
        }
        return false;
    }

    private static class LabelHolder
    extends ComponentHolder<String, JLabel> {
        private LabelHolder() {
        }

        @Override
        protected void setValue(JLabel component, String value) {
            component.setText(value);
        }

        @Override
        protected JLabel createComponent() {
            return new JLabel();
        }
    }

    private static class ImageComponentHolder
    extends ComponentHolder<Icon, ImageComponent> {
        private ImageComponentHolder() {
        }

        @Override
        protected void setValue(ImageComponent component, Icon value) {
            component.setIcon(value);
        }

        @Override
        protected ImageComponent createComponent() {
            return new ImageComponent();
        }
    }

    private static abstract class ComponentHolder<V, C extends JComponent> {
        private C myComponent;

        private ComponentHolder() {
        }

        public final boolean updateValue(V value) {
            boolean updateLayout;
            if (value == null) {
                updateLayout = this.myComponent != null;
                this.myComponent = null;
            } else {
                if (this.myComponent == null) {
                    updateLayout = true;
                    this.myComponent = this.createComponent();
                } else {
                    updateLayout = false;
                }
                this.setValue(this.myComponent, value);
            }
            return updateLayout;
        }

        protected abstract void setValue(C var1, V var2);

        protected abstract C createComponent();

        public final C getComponent() {
            return this.myComponent;
        }
    }
}

