/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.LongRunningOperationPath;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.dynamic.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConsolidatedProgressStep
extends ProgressStep {
    private final AtomicBoolean myIsBusy = new AtomicBoolean(false);
    private final DynamicWizardHost myHost;
    private List<? extends AndroidStudioWizardPath> myPaths;

    public ConsolidatedProgressStep(Disposable disposable, DynamicWizardHost host) {
        super(disposable);
        this.myHost = host;
    }

    public void setPaths(List<? extends AndroidStudioWizardPath> paths) {
        this.myPaths = paths;
    }

    @Override
    public boolean canGoNext() {
        return super.canGoNext() && !this.myIsBusy.get();
    }

    @Override
    protected void execute() {
        this.myIsBusy.set(true);
        this.myHost.runSensitiveOperation(this.getProgressIndicator(), true, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConsolidatedProgressStep.this.doLongRunningOperation(ConsolidatedProgressStep.this);
                }
                catch (WizardException e) {
                    Logger.getInstance(this.getClass()).error((Throwable)e);
                    ConsolidatedProgressStep.this.showConsole();
                    ConsolidatedProgressStep.this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
                finally {
                    ConsolidatedProgressStep.this.myIsBusy.set(false);
                }
            }
        });
    }

    private void doLongRunningOperation(ProgressStep progressStep) throws WizardException {
        for (AndroidStudioWizardPath androidStudioWizardPath : this.myPaths) {
            if (progressStep.isCanceled()) break;
            if (!(androidStudioWizardPath instanceof LongRunningOperationPath)) continue;
            ((LongRunningOperationPath)((Object)androidStudioWizardPath)).runLongOperation();
        }
    }

    @Override
    public boolean canGoPrevious() {
        return false;
    }

    @Override
    public boolean isStepVisible() {
        return this.myPaths != null && !this.myPaths.isEmpty();
    }
}

