/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public abstract class InstallableComponent
extends ComponentTreeNode {
    protected final ScopedStateStore.Key<Boolean> myKey;
    protected final ScopedStateStore myStateStore;
    private final String myName;
    private final long mySize;
    private Boolean myUserSelection;
    private boolean myIsOptional = true;
    private boolean myIsInstalled = false;

    public InstallableComponent(ScopedStateStore stateStore, String name, long size, String description) {
        super(description);
        this.myStateStore = stateStore;
        this.myName = name;
        this.mySize = size;
        this.myKey = stateStore.createKey("component.enabled." + System.identityHashCode(this), Boolean.class);
    }

    @Override
    public String getLabel() {
        String sizeLabel = this.isInstalled() ? "installed" : WelcomeUIUtils.getSizeLabel(this.mySize);
        return String.format("%s \u2013 (%s)", this.myName, sizeLabel);
    }

    private boolean isInstalled() {
        return this.myIsInstalled;
    }

    public abstract Collection<IPkgDesc> getRequiredSdkPackages(Multimap<PkgType, RemotePkgInfo> var1);

    public abstract void configure(InstallContext var1, File var2);

    protected boolean isSelectedByDefault(SdkManager sdkManager) {
        return true;
    }

    @Override
    public boolean isOptional() {
        return this.myIsOptional;
    }

    protected boolean isOptionalForSdkLocation(SdkManager manager) {
        return true;
    }

    @Override
    public Collection<InstallableComponent> getChildrenToInstall() {
        if (!this.myStateStore.getNotNull(this.myKey, true).booleanValue()) {
            return Collections.emptySet();
        }
        return Collections.singleton(this);
    }

    @Override
    public Collection<DynamicWizardStep> createSteps() {
        return Collections.emptySet();
    }

    @Override
    public void updateState(SdkManager manager) {
        boolean nothingToInstall = this.getRequiredSdkPackages(null).isEmpty();
        boolean bl = this.myIsOptional = !nothingToInstall && this.isOptionalForSdkLocation(manager);
        boolean isSelected = !this.myIsOptional ? !nothingToInstall : (this.myUserSelection != null ? this.myUserSelection.booleanValue() : this.isSelectedByDefault(manager));
        this.myStateStore.put(this.myKey, isSelected);
        this.myIsInstalled = this.checkInstalledPackages(manager);
    }

    private boolean checkInstalledPackages(SdkManager manager) {
        if (manager != null) {
            LocalSdk localSdk = manager.getLocalSdk();
            LocalPkgInfo[] pkgsInfos = localSdk.getPkgsInfos(EnumSet.allOf(PkgType.class));
            HashSet descs = Sets.newHashSetWithExpectedSize((int)pkgsInfos.length);
            for (LocalPkgInfo pkgsInfo : pkgsInfos) {
                IPkgDesc desc = pkgsInfo.getDesc();
                descs.add(desc.getPath());
            }
            Collection<IPkgDesc> requiredSdkPackages = this.getRequiredSdkPackages(null);
            if (requiredSdkPackages.isEmpty()) {
                return false;
            }
            for (IPkgDesc desc : requiredSdkPackages) {
                if (descs.contains(desc.getPath())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void toggle(boolean isSelected) {
        if (this.myIsOptional) {
            this.myUserSelection = isSelected;
            this.myStateStore.put(this.myKey, isSelected);
        }
    }

    @Override
    public Collection<ComponentTreeNode> getImmediateChildren() {
        return Collections.emptySet();
    }

    @Override
    public boolean isChecked() {
        return this.myStateStore.getNotNull(this.myKey, true);
    }

    public long getInstalledSize() {
        return this.myIsInstalled ? 0L : this.mySize;
    }

    @Override
    public boolean componentStateChanged(Set<ScopedStateStore.Key> modified) {
        return modified.contains(this.myKey);
    }
}

