/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.SdkManager;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class ComponentCategory
extends ComponentTreeNode {
    private final String myName;
    private final Collection<ComponentTreeNode> myComponents;

    public ComponentCategory(String name, String description, ComponentTreeNode ... components) {
        this(name, description, Arrays.asList(components));
    }

    @Override
    public void init(ProgressStep progressStep) {
        for (ComponentTreeNode component : this.myComponents) {
            component.init(progressStep);
        }
    }

    public ComponentCategory(String name, String description, Collection<ComponentTreeNode> components) {
        super(description);
        this.myName = name;
        this.myComponents = components;
    }

    @Override
    public String getLabel() {
        return this.myName;
    }

    @Override
    public Collection<InstallableComponent> getChildrenToInstall() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ComponentTreeNode component : this.myComponents) {
            builder.addAll(component.getChildrenToInstall());
        }
        return builder.build();
    }

    @Override
    public void updateState(SdkManager manager) {
        for (ComponentTreeNode component : this.myComponents) {
            component.updateState(manager);
        }
    }

    @Override
    public Collection<DynamicWizardStep> createSteps() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ComponentTreeNode component : this.myComponents) {
            builder.addAll(component.createSteps());
        }
        return builder.build();
    }

    @Override
    public boolean isChecked() {
        for (ComponentTreeNode component : this.myComponents) {
            if (component.isChecked()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean componentStateChanged(Set<ScopedStateStore.Key> modified) {
        for (ComponentTreeNode component : this.myComponents) {
            if (!component.componentStateChanged(modified)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ComponentTreeNode> getImmediateChildren() {
        return this.myComponents;
    }

    @Override
    public boolean isOptional() {
        for (ComponentTreeNode component : this.myComponents) {
            if (!component.isOptional()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toggle(boolean isSelected) {
        for (ComponentTreeNode component : this.myComponents) {
            component.toggle(isSelected);
        }
    }
}

