/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.expressions.integer;

import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.IntValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpression;

public abstract class ComparisonExpression
extends BooleanExpression {
    private final ObservableValue<Integer> myValueLhs;
    private final ObservableValue<Integer> myValueRhs;

    public static ObservableBool isEqual(ObservableValue<Integer> valueLhs, ObservableValue<Integer> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs == valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThan(ObservableValue<Integer> valueLhs, ObservableValue<Integer> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs > valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThanEqual(ObservableValue<Integer> valueLhs, ObservableValue<Integer> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs >= valueRhs;
            }
        };
    }

    public static ObservableBool isLessThan(ObservableValue<Integer> valueLhs, ObservableValue<Integer> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs < valueRhs;
            }
        };
    }

    public static ObservableBool isLessThanEqual(ObservableValue<Integer> valueLhs, ObservableValue<Integer> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs <= valueRhs;
            }
        };
    }

    public static ObservableBool isEqual(ObservableValue<Integer> valueLhs, int valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new IntValueProperty(valueRhs)){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs == valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThan(ObservableValue<Integer> valueLhs, int valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new IntValueProperty(valueRhs)){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs > valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThanEqual(ObservableValue<Integer> valueLhs, int valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new IntValueProperty(valueRhs)){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs >= valueRhs;
            }
        };
    }

    public static ObservableBool isLessThan(ObservableValue<Integer> valueLhs, int valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new IntValueProperty(valueRhs)){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs < valueRhs;
            }
        };
    }

    public static ObservableBool isLessThanEqual(ObservableValue<Integer> valueLhs, int valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new IntValueProperty(valueRhs)){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs <= valueRhs;
            }
        };
    }

    protected ComparisonExpression(ObservableValue<Integer> valueLhs, ObservableValue<Integer> valueRhs) {
        super(valueLhs, valueRhs);
        this.myValueLhs = valueLhs;
        this.myValueRhs = valueRhs;
    }

    @Override
    public final Boolean get() {
        return this.compare(this.myValueLhs.get(), this.myValueRhs.get());
    }

    protected abstract Boolean compare(int var1, int var2);
}

