/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.core;

import com.android.tools.idea.ui.properties.ObservableProperty;
import com.google.common.base.Optional;

public final class OptionalProperty<T>
extends ObservableProperty<Optional<T>> {
    private Optional<T> myOptional;

    public static <T> OptionalProperty<T> of(T value) {
        return new OptionalProperty<T>(value);
    }

    public static <T> OptionalProperty<T> absent() {
        return new OptionalProperty<T>();
    }

    public OptionalProperty() {
        this.myOptional = Optional.absent();
    }

    public OptionalProperty(T value) {
        this.myOptional = Optional.of(value);
    }

    @Override
    public Optional<T> get() {
        return this.myOptional;
    }

    public T getValue() {
        return (T)this.myOptional.get();
    }

    public void setValue(T value) {
        if (!this.myOptional.isPresent() || !this.myOptional.get().equals(value)) {
            this.set(Optional.of(value));
        }
    }

    public void clear() {
        if (this.myOptional.isPresent()) {
            this.set(Optional.absent());
        }
    }

    public T getValueOr(T defaultValue) {
        return (T)this.myOptional.or(defaultValue);
    }

    public T getValueOrNull() {
        return (T)this.myOptional.orNull();
    }

    public boolean isPresent() {
        return this.myOptional.isPresent();
    }

    @Override
    protected void setDirectly(Optional<T> value) {
        this.myOptional = value;
    }
}

