/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.android.tools.idea.stats.Distribution;
import com.android.tools.idea.stats.DistributionService;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JPanel;

public class DistributionChartComponent
extends JPanel {
    private static final Color TEXT_COLOR = new Color(0xFEFEFE);
    private static final Color API_LEVEL_COLOR = new Color(0, 0, 0, 77);
    private static final int INTER_SECTION_SPACING = 1;
    private static final double MIN_PERCENTAGE_HEIGHT = 0.06;
    private static final double EXPANSION_ON_SELECTION = 1.063882064;
    private static final double RIGHT_GUTTER_PERCENTAGE = 0.209708738;
    private static final int TOP_PADDING = 40;
    private static final int NAME_OFFSET = 50;
    private static final int MIN_API_FONT_SIZE = JBUI.scale((int)18);
    private static final int MAX_API_FONT_SIZE = JBUI.scale((int)45);
    private static final int API_OFFSET = 120;
    private static final int NUMBER_OFFSET = 10;
    private static Font MEDIUM_WEIGHT_FONT;
    private static Font REGULAR_WEIGHT_FONT;
    private static Font VERSION_NAME_FONT;
    private static Font VERSION_NUMBER_FONT;
    private static Font TITLE_FONT;
    private static final Color[] RECT_COLORS;
    private static List<Distribution> ourDistributions;
    private int[] myCurrentBottoms;
    private Distribution mySelectedDistribution;
    private DistributionSelectionChangedListener myListener;

    public void init() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int i;
                int y = mouseEvent.getY();
                for (i = 0; i < DistributionChartComponent.this.myCurrentBottoms.length && y > DistributionChartComponent.this.myCurrentBottoms[i]; ++i) {
                }
                if (i < DistributionChartComponent.this.myCurrentBottoms.length) {
                    DistributionChartComponent.this.selectDistribution((Distribution)ourDistributions.get(i));
                }
            }
        });
        if (ourDistributions == null) {
            ourDistributions = DistributionService.getInstance().getDistributions();
        }
        DistributionChartComponent.loadFonts();
    }

    public void selectDistribution(Distribution d) {
        this.mySelectedDistribution = d;
        if (this.myListener != null) {
            this.myListener.onDistributionSelected(this.mySelectedDistribution);
        }
        this.repaint();
    }

    private static void loadFonts() {
        if (MEDIUM_WEIGHT_FONT == null) {
            REGULAR_WEIGHT_FONT = new Font("Sans", 0, 12);
            MEDIUM_WEIGHT_FONT = new Font("Sans", 1, 12);
            VERSION_NAME_FONT = REGULAR_WEIGHT_FONT.deriveFont(JBUI.scale((float)16.0f));
            VERSION_NUMBER_FONT = REGULAR_WEIGHT_FONT.deriveFont(JBUI.scale((float)20.0f));
            TITLE_FONT = MEDIUM_WEIGHT_FONT.deriveFont(JBUI.scale((float)16.0f));
        }
    }

    public void registerDistributionSelectionChangedListener(DistributionSelectionChangedListener listener) {
        this.myListener = listener;
    }

    @Override
    public Dimension getMinimumSize() {
        return JBUI.size((int)300, (int)300);
    }

    @Override
    public void paintComponent(Graphics g) {
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        super.paintComponent(g);
        if (this.myCurrentBottoms == null) {
            this.myCurrentBottoms = new int[ourDistributions.size()];
        }
        int startY = 40;
        int totalWidth = this.getBounds().width;
        int rightGutter = (int)Math.round((double)totalWidth * 0.209708738);
        int width = totalWidth - rightGutter;
        int normalBoxSize = (int)Math.round((double)width / 1.063882064);
        int leftGutter = (width - normalBoxSize) / 2;
        FontMetrics titleMetrics = g.getFontMetrics(TITLE_FONT);
        int titleHeight = titleMetrics.getHeight();
        FontMetrics versionNumberMetrics = g.getFontMetrics(VERSION_NUMBER_FONT);
        int halfVersionNumberHeight = (versionNumberMetrics.getHeight() - versionNumberMetrics.getDescent()) / 2;
        FontMetrics versionNameMetrics = g.getFontMetrics(VERSION_NAME_FONT);
        int halfVersionNameHeight = (versionNameMetrics.getHeight() - versionNameMetrics.getDescent()) / 2;
        g.setFont(TITLE_FONT);
        g.drawString("Android Platform".toUpperCase(), leftGutter, titleHeight);
        g.drawString("Version".toUpperCase(), leftGutter, titleHeight * 2);
        g.drawString("API Level".toUpperCase(), width - 120, titleHeight);
        String accumulativeTitle = "Cumulative".toUpperCase();
        String distributionTitle = "Distribution".toUpperCase();
        g.drawString(accumulativeTitle, totalWidth - titleMetrics.stringWidth(accumulativeTitle), titleHeight);
        g.drawString(distributionTitle, totalWidth - titleMetrics.stringWidth(distributionTitle), titleHeight * 2);
        int heightToDistribute = this.getBounds().height - 1 * (ourDistributions.size() - 1) - 40;
        double percentageSum = 0.0;
        int smallItemCount = 0;
        for (Distribution d : ourDistributions) {
            if (!(d.getDistributionPercentage() < 0.06)) continue;
            ++smallItemCount;
        }
        heightToDistribute -= (int)Math.round((double)smallItemCount * 0.06 * (double)heightToDistribute);
        int i = 0;
        for (Distribution d : ourDistributions) {
            g.setColor(RECT_COLORS[i % RECT_COLORS.length]);
            double effectivePercentage = Math.max(d.getDistributionPercentage(), 0.06);
            int calculatedHeight = (int)Math.round(effectivePercentage * (double)heightToDistribute);
            int bottom = startY + calculatedHeight;
            if (d.equals(this.mySelectedDistribution)) {
                g.fillRect(0, bottom - calculatedHeight, width, calculatedHeight);
            } else {
                g.fillRect(leftGutter, bottom - calculatedHeight, normalBoxSize, calculatedHeight);
            }
            Font apiLevelFont = REGULAR_WEIGHT_FONT.deriveFont(DistributionChartComponent.logistic(effectivePercentage, MIN_API_FONT_SIZE, MAX_API_FONT_SIZE));
            FontMetrics apiLevelMetrics = g.getFontMetrics(apiLevelFont);
            int halfApiFontHeight = (apiLevelMetrics.getHeight() - apiLevelMetrics.getDescent()) / 2;
            int currentMidY = startY + calculatedHeight / 2;
            g.setColor(TEXT_COLOR);
            g.setFont(VERSION_NAME_FONT);
            this.myCurrentBottoms[i] = bottom;
            g.drawString(d.getName(), leftGutter + 50, currentMidY + halfVersionNameHeight);
            g.setColor(API_LEVEL_COLOR);
            g.setFont(VERSION_NUMBER_FONT);
            String versionString = d.getVersion().toString().substring(0, 3);
            g.drawString(versionString, leftGutter + 10, currentMidY + halfVersionNumberHeight);
            g.setFont(apiLevelFont);
            g.drawString(Integer.toString(d.getApiLevel()), width - 120, currentMidY + halfApiFontHeight);
            percentageSum += d.getDistributionPercentage();
            if (i < ourDistributions.size() - 1) {
                g.setColor(JBColor.foreground());
                g.setFont(VERSION_NUMBER_FONT);
                String percentageString = percentageSum > 0.999 ? "< 0.1%" : new DecimalFormat("0.0%").format(1.0 - percentageSum);
                int percentStringWidth = versionNumberMetrics.stringWidth(percentageString);
                g.drawString(percentageString, totalWidth - percentStringWidth - 2, bottom - 2);
                g.setColor((Color)JBColor.darkGray);
                g.drawLine(leftGutter + normalBoxSize, startY + calculatedHeight, totalWidth, startY + calculatedHeight);
            }
            startY += calculatedHeight + 1;
            ++i;
        }
    }

    private static float logistic(double normalizedValue, int min, int max) {
        double t = normalizedValue * 1.0;
        double result = (double)(max * min) * Math.exp((double)min * t) / ((double)max + (double)min * Math.exp((double)min * t));
        return (float)result;
    }

    static {
        RECT_COLORS = new Color[]{new Color(13361099), new Color(8242833), new Color(9614007), new Color(14596672), new Color(15031647), new Color(7258322), new Color(14191971), new Color(0xFF9229), new Color(15383853)};
    }

    public static interface DistributionSelectionChangedListener {
        public void onDistributionSelected(Distribution var1);
    }
}

